/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.broadcast.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordBroadcastMicroServiceRegistryDeleted
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"3ffef98e-c241-4949-91ec-6436661301b8");
    public static final String NAME = "BroadcastMicroServiceRegistryDeleted";
    public static final String DESCRIPTION = "Broadcast Message to announce the removal of a MicroService Registry.";
    public static final String SLOT_MICRO_SERVICE_ADDRESS = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getMicroServiceAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setMicroServiceAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_ADDRESS, slot);
    }
}

