/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.nodeinfo;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.ENodeStatus;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordDataNodeInfo;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CNodeInfoDto {
    private static final long TIMEOUT_NODE_RECORD_REQUESTED = 30000L;
    private static final long TIMEOUT_NODE_RECORD_OLD = 21600000L;
    private static final ILogger LOG = CLoggerFactory.getLogger(CNodeInfoDto.class);
    private final CNodeAddress mNodeAddress;
    private final ZonedDateTime mTimestampCreation;
    private ZonedDateTime mStartTime;
    private String mName = "";
    private String mVendor = "";
    private String mDescription = "";
    private UUID mLicense = null;
    private long mTimestampHisSessionKey = 0L;
    private long mTimestampMySessionKey = 0L;
    private long mTimestampNodeRecordRequested = 0L;
    private String mHisPacketBuilderSequence = "";
    private String mMyPacketBuilderSequence = "";
    private SecretKey mHisSessionKey;
    private SecretKey mMySessionKey;
    private List<CMessage> mPendingMessages = null;
    private UUID mInstanceId;
    @NotNull
    private ETypeOfNode mTypeOfNode = ETypeOfNode.UNKNOWN;
    private ENodeStatus mNodeStatus = ENodeStatus.unknown;
    private final AtomicBoolean mNotifyRemoteNodeRemovedSent = new AtomicBoolean();
    private final AtomicBoolean mNotifyRemoteNodeAddedSent = new AtomicBoolean();

    public CNodeInfoDto(@NotNull CNodeAddress aNodeAddress) {
        this(aNodeAddress, null);
    }

    public CNodeInfoDto(@NotNull CNodeAddress aNodeAddress, @Nullable UUID aInstanceId) {
        this.mNodeAddress = aNodeAddress;
        this.mInstanceId = aInstanceId;
        this.mTimestampCreation = ZonedDateTime.now();
        this.mStartTime = ZonedDateTime.now();
        this.mNodeStatus = this.mNodeAddress.isLocalNode() ? ENodeStatus.local : ENodeStatus.unknown;
    }

    public CNodeInfoDto(@NotNull CNodeInfoDto aSrc) {
        this.mNodeAddress = aSrc.mNodeAddress;
        this.mName = aSrc.mName;
        this.mVendor = aSrc.mVendor;
        this.mDescription = aSrc.mDescription;
        this.mLicense = aSrc.mLicense;
        this.mTimestampCreation = aSrc.mTimestampCreation;
        this.mTimestampHisSessionKey = aSrc.mTimestampHisSessionKey;
        this.mTimestampMySessionKey = aSrc.mTimestampMySessionKey;
        this.mTimestampNodeRecordRequested = aSrc.mTimestampNodeRecordRequested;
        this.mHisPacketBuilderSequence = aSrc.mHisPacketBuilderSequence;
        this.mMyPacketBuilderSequence = aSrc.mMyPacketBuilderSequence;
        this.mHisSessionKey = aSrc.mHisSessionKey;
        this.mMySessionKey = aSrc.mMySessionKey;
        this.mPendingMessages = new ArrayList<CMessage>(aSrc.mPendingMessages);
        this.mInstanceId = aSrc.mInstanceId;
        this.mTypeOfNode = aSrc.mTypeOfNode;
        this.mNodeStatus = this.mNodeAddress.isLocalNode() ? ENodeStatus.local : ENodeStatus.unknown;
        this.mStartTime = aSrc.mStartTime;
    }

    @Nullable
    public static CNodeInfoDto fromRecord(@NotNull CRecord aRecord) {
        IId id = aRecord.getId();
        if (!CRecordDataNodeInfo.ID.equals((Object)id)) {
            LOG.warn("NodeRecord has wrong ID");
            return null;
        }
        CNodeAddress node = CRecordDataNodeInfo.getNode(aRecord, null);
        if (node == null) {
            LOG.warn("NodeRecord has no address");
            return null;
        }
        CNodeInfoDto dto = new CNodeInfoDto(node);
        dto.setName(CRecordDataNodeInfo.getName(aRecord, ""));
        dto.setDescription(CRecordDataNodeInfo.getDescription(aRecord, ""));
        dto.setVendor(CRecordDataNodeInfo.getVendor(aRecord, ""));
        dto.setLicense(CRecordDataNodeInfo.getLicense(aRecord, null));
        dto.setHisPacketBuilderSequence(CRecordDataNodeInfo.getPacketBuilderSequence(aRecord, "M"));
        dto.setInstanceId(CRecordDataNodeInfo.getInstanceId(aRecord, null));
        String s = CRecordDataNodeInfo.getTypeOfNode(aRecord, null);
        ETypeOfNode typeOfNode = (ETypeOfNode)CUtilEnum.fromString(ETypeOfNode.class, (String)s, (Object)ETypeOfNode.UNKNOWN);
        dto.setTypeOfNode(typeOfNode);
        dto.mNodeStatus = dto.mNodeAddress.isLocalNode() ? ENodeStatus.local : ENodeStatus.unknown;
        dto.setStartTime(CRecordDataNodeInfo.getStartTime(aRecord, ZonedDateTime.now()));
        return dto;
    }

    public void setStartTime(@NotNull ZonedDateTime aStartTime) {
        this.mStartTime = aStartTime;
    }

    @NotNull
    public ZonedDateTime getStartTime() {
        return this.mStartTime;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public String getHisPacketBuilderSequence() {
        return this.mHisPacketBuilderSequence;
    }

    public void setHisPacketBuilderSequence(String aHisPacketBuilderSequence) {
        this.mHisPacketBuilderSequence = aHisPacketBuilderSequence;
    }

    public SecretKey getHisSessionKey() {
        return this.mHisSessionKey;
    }

    public void setHisSessionKey(SecretKey aHisSessionKey) {
        this.mHisSessionKey = aHisSessionKey;
    }

    public UUID getLicense() {
        return this.mLicense;
    }

    public void setLicense(UUID aLicense) {
        this.mLicense = aLicense;
    }

    public String getMyPacketBuilderSequence() {
        return this.mMyPacketBuilderSequence;
    }

    public void setMyPacketBuilderSequence(String aMyPacketBuilderSequence) {
        this.mMyPacketBuilderSequence = aMyPacketBuilderSequence;
    }

    public SecretKey getMySessionKey() {
        return this.mMySessionKey;
    }

    public void setMySessionKey(SecretKey aMySessionKey) {
        this.mMySessionKey = aMySessionKey;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }

    public List<CMessage> getPendingMessages() {
        return this.mPendingMessages;
    }

    public void setPendingMessages(List<CMessage> aPendingMessages) {
        this.mPendingMessages = aPendingMessages;
    }

    public ZonedDateTime getTimestampCreation() {
        return this.mTimestampCreation;
    }

    public long getTimestampHisSessionKey() {
        return this.mTimestampHisSessionKey;
    }

    public void setTimestampHisSessionKey(long aTimestampHisSessionKey) {
        this.mTimestampHisSessionKey = aTimestampHisSessionKey;
    }

    public long getTimestampMySessionKey() {
        return this.mTimestampMySessionKey;
    }

    public void setTimestampMySessionKey(long aTimestampMySessionKey) {
        this.mTimestampMySessionKey = aTimestampMySessionKey;
    }

    public long getTimestampNodeRecordRequested() {
        return this.mTimestampNodeRecordRequested;
    }

    public void setTimestampNodeRecordRequested(long aTimestampNodeRecordRequested) {
        this.mTimestampNodeRecordRequested = aTimestampNodeRecordRequested;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    public void saveMessage(@NotNull CMessage aMessage) {
        if (this.mPendingMessages == null) {
            this.mPendingMessages = new ArrayList<CMessage>();
        }
        this.mPendingMessages.add(aMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        if (CUtilString.isEmpty((String)this.mName)) {
            sb.append("NoName");
        } else {
            sb.append(this.mName);
        }
        sb.append(" (");
        sb.append(this.mNodeAddress);
        sb.append(") ");
        if (!CUtilString.isEmpty((String)this.mVendor)) {
            sb.append("from ");
            sb.append(this.mVendor);
            sb.append(' ');
        }
        if (!CUtilString.isEmpty((String)this.mDescription)) {
            sb.append('[');
            sb.append(this.mDescription);
            sb.append(']');
        }
        if (this.mLicense != null) {
            sb.append("[License=");
            sb.append(this.mLicense);
            sb.append(']');
        }
        return sb.toString();
    }

    public UUID getInstanceId() {
        return this.mInstanceId;
    }

    public void setInstanceId(@NotNull UUID aInstanceId) {
        this.mInstanceId = aInstanceId;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CNodeInfoDto that = (CNodeInfoDto)aO;
        return this.mNodeAddress.equals((Object)that.mNodeAddress) && this.mInstanceId.equals(that.mInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.mNodeAddress, this.mInstanceId);
    }

    public CNodeInfo getNodeInfo() {
        return new CNodeInfo(this.mNodeAddress, this.mName, this.mDescription, this.mLicense, this.mVendor, this.mInstanceId, this.mStartTime);
    }

    public void resetIfOtherInstanceId(@NotNull UUID aInstanceId) {
        if (!aInstanceId.equals(this.mInstanceId)) {
            this.mInstanceId = aInstanceId;
            this.mHisPacketBuilderSequence = "M";
            this.mHisSessionKey = null;
        }
    }

    public boolean isClient() {
        return ETypeOfNode.CLIENT.equals((Object)this.mTypeOfNode);
    }

    public void setTypeOfNode(@NotNull ETypeOfNode aTypeOfNode) {
        this.mTypeOfNode = aTypeOfNode;
    }

    @NotNull
    public ETypeOfNode getTypeOfNode() {
        return this.mTypeOfNode;
    }

    public void toRecord(@NotNull CRecord aRecord) throws CException {
        CUtilCheck.checkEqual((Object)aRecord.getId(), (Object)CRecordDataNodeInfo.ID, (String)"Record ID is not correct", (Object[])new Object[0]);
        CRecordDataNodeInfo.setNode(aRecord, this.mNodeAddress);
        CRecordDataNodeInfo.setDescription(aRecord, this.mDescription);
        CRecordDataNodeInfo.setLicense(aRecord, this.mLicense);
        CRecordDataNodeInfo.setName(aRecord, this.mName);
        CRecordDataNodeInfo.setPacketBuilderSequence(aRecord, this.mHisPacketBuilderSequence);
        CRecordDataNodeInfo.setVendor(aRecord, this.mVendor);
        CRecordDataNodeInfo.setInstanceId(aRecord, this.mInstanceId);
        CRecordDataNodeInfo.setTypeOfNode(aRecord, this.mTypeOfNode.name());
    }

    public String dump() {
        String format = "%20s %s\n";
        StringBuilder sb = new StringBuilder(600);
        sb.append(CUtilString.LINE_CRLF);
        sb.append("Node added:");
        sb.append(CUtilString.CRLF);
        sb.append(String.format("%20s %s\n", "Address", this.mNodeAddress));
        sb.append(String.format("%20s %s\n", "InstanceId", this.mInstanceId));
        sb.append(String.format("%20s %s\n", "Name", this.mName));
        sb.append(String.format("%20s %s\n", "Description", this.mDescription));
        sb.append(String.format("%20s %s\n", "typeOfNode", this.mTypeOfNode));
        sb.append(CUtilString.LINE);
        return sb.toString();
    }

    public boolean isRecordRequested() {
        long now = System.currentTimeMillis();
        return now - this.getTimestampNodeRecordRequested() < 30000L;
    }

    public void invalidate() {
        this.setTimestampHisSessionKey(0L);
        this.setTimestampNodeRecordRequested(0L);
    }

    public boolean isValidated() {
        long now = System.currentTimeMillis();
        return now - this.getTimestampHisSessionKey() < 21600000L;
    }

    public void setValidated() {
        Date date = new Date();
        this.setTimestampHisSessionKey(date.getTime());
        this.setTimestampNodeRecordRequested(0L);
        this.mNotifyRemoteNodeRemovedSent.set(false);
        this.setNodeStatus(ENodeStatus.online);
    }

    public ENodeStatus getNodeStatus() {
        return this.mNodeStatus;
    }

    public void setNodeStatus(@NotNull ENodeStatus aNodeStatus) {
        this.mNodeStatus = aNodeStatus;
    }

    public AtomicBoolean getNotifyRemoteNodeRemovedSent() {
        return this.mNotifyRemoteNodeRemovedSent;
    }

    public AtomicBoolean getNotifyRemoteNodeAddedSent() {
        return this.mNotifyRemoteNodeAddedSent;
    }
}

