/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.transport.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordServiceNotifyTransportClosed
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"ec8dcf82-6420-4e41-b19d-475d096f3536");
    public static final String NAME = "ServiceNotifyTransportClosed";
    public static final String DESCRIPTION = "Notification (from Transport to ConnectionRegistry) that the transport target has been closed.";
    public static final String SLOT_CONNECTION_ID = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getConnectionId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static void setConnectionId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_ID, slot);
    }
}

