/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.broadcast;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.broadcast.CBroadcastHistory;
import de.sillysky.nyssr.impl.network.broadcast.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.network.broadcast.IBroadcastService;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastSendMsg;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastTransportMsg;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CBroadcastService
extends CTarget
implements IBroadcastService,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CBroadcastService.class);
    private CBroadcastHistory mBroadcastHistory;
    private final IDependencies mDependencies;
    private final AtomicInteger mBroadcastIdCounter = new AtomicInteger(0);

    CBroadcastService(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordBroadcastSendMsg.ID, this::asyncSendBroadcastMsg);
        this.addMessageHandler(CRecordBroadcastTransportMsg.ID, this::asyncTransportBroadcastMsg);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        this.mBroadcastHistory = new CBroadcastHistory();
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "TRANSPORT");
        ns.getTargetRegistry().registerTarget((ITarget)this, CWellKnownTID.BROADCAST);
        aServiceRegistry.registerService(IBroadcastService.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    public void broadcastMessage(@NotNull CMessage aMessage, boolean aLocallyToo) {
        this.broadcastMessage(aMessage, null, null, aLocallyToo);
    }

    public void broadcastMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, boolean aLocallyToo) throws CException {
        CTargetAddress receiver = aEnvelope.getReceiver();
        if (CIdFactory.isEmpty((IId)receiver.getNID())) {
            throw new CException(2509).append("NID missing");
        }
        CMessage msg = new CMessage(aEnvelope, aRecord);
        this.broadcastMessage(msg, null, null, aLocallyToo);
    }

    public void broadcastMessage(@NotNull CMessage aMsg, @Nullable Collection<CNodeAddress> aPosFilter, @Nullable Collection<CNodeAddress> aNegFilter, boolean aLocallyToo) {
        String broadcastId = this.createBroadcastId();
        CEnvelope env = aMsg.getEnvelope();
        CRecord rec = aMsg.getRecord();
        IId id = rec.getId();
        LOG.debug("Broadcast {}: send message {} instance={}", new Object[]{broadcastId, env.getInstanceId()});
        if (aLocallyToo) {
            try {
                this.mDependencies.getMessageSender().send(aMsg);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Broadcast {}: Could not forward broadcast to local system.", new Object[]{broadcastId});
            }
        }
        CTargetAddress sender = env.getSender();
        this.floodFiltered(sender, aMsg, broadcastId, aPosFilter, aNegFilter);
    }

    @NotNull
    private String createBroadcastId() {
        return CNodeId.getLocal().toString() + this.mBroadcastIdCounter.getAndIncrement() + "-" + this.mDependencies.getKernelConfiguration().getInstanceId();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(address, "BroadcastTarget");
        INamespace system = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        assert (system != null);
        INanoServiceRegistry nsr = system.getNanoServiceRegistry();
        nsr.addObserver(CRecordBroadcastSendMsg.class, this.getAddress(), false);
        nsr.addObserver(CRecordBroadcastTransportMsg.class, this.getAddress(), false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSendBroadcastMsg(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CMessage message = CRecordBroadcastSendMsg.getMessage((CRecord)aRecord, null);
        boolean locallyToo = CRecordBroadcastSendMsg.getLocally((CRecord)aRecord, (boolean)false);
        List<CNodeAddress> negFilter = null;
        CNodeAddress[] negFilterArr = CRecordBroadcastSendMsg.getNegativeFilter((CRecord)aRecord, null);
        if (negFilterArr != null) {
            negFilter = Arrays.asList(negFilterArr);
        }
        List<CNodeAddress> posFilter = null;
        CNodeAddress[] posFilterArr = CRecordBroadcastSendMsg.getPositiveFilter((CRecord)aRecord, null);
        if (posFilterArr != null) {
            posFilter = Arrays.asList(posFilterArr);
        }
        CTargetAddress sender = aEnvelope.getSender();
        CTargetAddress receiver = aEnvelope.getReceiver();
        if (message == null) {
            aEnvelope.setResult(7, "Missing Message");
        } else if (!sender.isValid()) {
            aEnvelope.setResult(7, "Invalid Sender");
        } else if (!receiver.isValid()) {
            aEnvelope.setResult(7, "Invalid Receiver");
        } else {
            aEnvelope.setResultSuccess();
        }
        if (!CNodeId.getLocal().equals((Object)sender.getNodeId())) {
            CTargetAddress newSender = new CTargetAddress(sender.getTID(), sender.getNID(), CNodeId.getLocal(), CSegmentId.getLocal());
            aEnvelope.setSender(newSender);
        }
        assert (message != null);
        this.broadcastMessage(message, posFilter, negFilter, locallyToo);
        return true;
    }

    private boolean asyncTransportBroadcastMsg(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CMessage message = CRecordBroadcastTransportMsg.getMessage((CRecord)aRecord, null);
        if (message == null) {
            aEnvelope.setResult(7, "Missing Message");
            return true;
        }
        String broadcastId = CRecordBroadcastTransportMsg.getBroadcastId((CRecord)aRecord, (String)"");
        if (broadcastId.isEmpty()) {
            aEnvelope.setResult(7, "Invalid Broadcast ID");
            return true;
        }
        CTargetAddress source = CRecordBroadcastTransportMsg.getSource((CRecord)aRecord, null);
        if (source == null) {
            aEnvelope.setResult(7, "Missing Source");
            return true;
        }
        CNodeAddress lastHop = aEnvelope.getSender().getNodeAddress();
        IId id = message.getRecord().getId();
        this.incomingBroadcastMessage(source, id, lastHop, message, broadcastId);
        aEnvelope.setResultSuccess();
        return true;
    }

    private void incomingBroadcastMessage(@NotNull CTargetAddress aSource, @NotNull IId aId, @NotNull CNodeAddress aLastHop, @NotNull CMessage aMsg, @NotNull String aBroadcastId) {
        if (this.mBroadcastHistory.dejaVu(aSource.getNodeId(), aId, aBroadcastId)) {
            LOG.debug("Broadcast {}: deja vue from {}, skipped.", new Object[]{aBroadcastId, aLastHop.getNodeId()});
            return;
        }
        LOG.debug("Broadcast {}: incoming from {}", new Object[]{aBroadcastId, aLastHop.getNodeId().toString()});
        CEnvelope env = aMsg.getEnvelope();
        CTargetAddress oldReceiver = env.getReceiver();
        CTargetAddress newReceiver = new CTargetAddress(oldReceiver.getTID(), oldReceiver.getNID(), CNodeAddress.getLocal());
        env.setReceiver(newReceiver);
        try {
            LOG.debug("Broadcast {}: send to local system: {}", new Object[]{aBroadcastId, aMsg});
            this.mDependencies.getMessageSender().send(aMsg);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Broadcast {}: Could not send to local system: {}", new Object[]{aBroadcastId, aMsg});
        }
        ArrayList<CNodeAddress> negFilter = new ArrayList<CNodeAddress>();
        negFilter.add(aLastHop);
        this.floodFiltered(aSource, aMsg, aBroadcastId, null, negFilter);
    }

    private void sendMsgExternal(@NotNull CNodeAddress aDestination, @NotNull CTargetAddress aSource, @NotNull CMessage aMsg, @NotNull String aBroadcastId) {
        if (!aDestination.equals((Object)CNodeAddress.getLocal()) && !aDestination.equals((Object)aSource.getNodeAddress())) {
            IId id = aMsg.getRecord().getId();
            CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeAddress)aDestination);
            env.setPacketBuilderSequence("M");
            try {
                CRecord rec = CRecordBroadcastTransportMsg.create();
                CRecordBroadcastTransportMsg.setMessage((CRecord)rec, (CMessage)aMsg);
                CRecordBroadcastTransportMsg.setSource((CRecord)rec, (CTargetAddress)aSource);
                CRecordBroadcastTransportMsg.setBroadcastId((CRecord)rec, (String)aBroadcastId);
                this.send(env, rec);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Broadcast {}: could not forward to {}.", new Object[]{aBroadcastId, aDestination});
            }
        }
    }

    private void floodFiltered(CTargetAddress aSource, @NotNull CMessage aMsg, @NotNull String aBroadcastId, @Nullable Collection<CNodeAddress> aPosFilter, @Nullable Collection<CNodeAddress> aNegFilter) {
        Collection neighborNodes = this.mDependencies.getConnectionRegistry().getNeighborNodes();
        if (neighborNodes.isEmpty()) {
            return;
        }
        boolean sent = false;
        for (CNodeAddress node : neighborNodes) {
            if (aPosFilter != null && !aPosFilter.contains(node) || aNegFilter != null && aNegFilter.contains(node)) continue;
            LOG.debug("Broadcast {}: flood to {}", new Object[]{aBroadcastId, node.getNodeId().toString()});
            this.sendMsgExternal(node, aSource, aMsg, aBroadcastId);
            sent = true;
        }
    }
}

