/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.connection.dto;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.network.connection.dto.EConnectionUsage;
import de.sillysky.nyssr.network.connection.records.CRecordDataConnection;
import de.sillysky.nyssr.network.connection.records.EConnectionType;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class CConnectionUtil {
    private CConnectionUtil() {
    }

    @NotNull
    public static CConnectionDto copy(@NotNull CConnectionDto aSrc) {
        CConnectionDto dto = new CConnectionDto(aSrc.getID());
        dto.setType(aSrc.getType());
        dto.setIncoming(aSrc.isIncoming());
        dto.setConnectionAddress(aSrc.getConnectionAddress());
        dto.setLocalAddress(aSrc.getLocalAddress());
        dto.setRemoteAddress(aSrc.getRemoteAddress());
        dto.setLocalPort(aSrc.getLocalPort());
        dto.setUsage(aSrc.getUsage());
        dto.setRemoteNodeAddress(aSrc.getRemoteNodeAddress());
        dto.setRemoteInstanceID(aSrc.getRemoteInstanceID());
        return dto;
    }

    private static int extractLocalPort(@NotNull String aLocalAddress) {
        int localPort;
        int i = aLocalAddress.lastIndexOf(58);
        if (i >= 0) {
            String s = aLocalAddress.substring(i + 1);
            localPort = CUtilInteger.fromString((String)s);
        } else {
            localPort = 0;
        }
        return localPort;
    }

    @NotNull
    public static CConnectionDto fromRecord(@NotNull CRecord aRecord) {
        UUID id = CRecordDataConnection.getConnectionId((CRecord)aRecord, (UUID)UUID.randomUUID());
        CConnectionDto dto = new CConnectionDto(id);
        String t = CRecordDataConnection.getConnectionType((CRecord)aRecord, (String)"");
        dto.setType(EConnectionType.valueOf((String)t));
        String localAddress = CRecordDataConnection.getLocalAddress((CRecord)aRecord, null);
        dto.setLocalAddress(localAddress);
        dto.setLocalPort(CConnectionUtil.extractLocalPort(localAddress));
        dto.setIncoming(CRecordDataConnection.getIncoming((CRecord)aRecord, (boolean)false));
        dto.setRemoteAddress(CRecordDataConnection.getRemoteAddress((CRecord)aRecord, null));
        dto.setConnectionAddress(CRecordDataConnection.getTargetAddress((CRecord)aRecord, null));
        String usage1 = CRecordDataConnection.getConnectionUsage((CRecord)aRecord, (String)EConnectionUsage.UNKNOWN.name());
        EConnectionUsage usage2 = EConnectionUsage.getByName(usage1);
        dto.setUsage(usage2);
        dto.setRemoteNodeAddress(CRecordDataConnection.getRemoteNodeAddress((CRecord)aRecord, null));
        dto.setRemoteInstanceID(CRecordDataConnection.getRemoteInstanceId((CRecord)aRecord, null));
        return dto;
    }

    @NotNull
    public static CRecord toRecord(@NotNull CConnectionDto aDto) throws CException {
        CRecord rec = CRecordDataConnection.create();
        CRecordDataConnection.setConnectionId((CRecord)rec, (UUID)aDto.getID());
        CRecordDataConnection.setConnectionType((CRecord)rec, (String)aDto.getType().name());
        CRecordDataConnection.setIncoming((CRecord)rec, (boolean)aDto.isIncoming());
        CRecordDataConnection.setLocalAddress((CRecord)rec, (String)aDto.getLocalAddress());
        CRecordDataConnection.setRemoteAddress((CRecord)rec, (String)aDto.getRemoteAddress());
        CRecordDataConnection.setTargetAddress((CRecord)rec, (CTargetAddress)aDto.getConnectionAddress());
        CRecordDataConnection.setConnectionUsage((CRecord)rec, (String)aDto.getUsage().name());
        CRecordDataConnection.setRemoteNodeAddress((CRecord)rec, (CNodeAddress)aDto.getRemoteNodeAddress());
        CRecordDataConnection.setRemoteInstanceId((CRecord)rec, (UUID)aDto.getRemoteInstanceID());
        return rec;
    }

    @NotNull
    public static String getDetailedInfo(@NotNull CConnectionDto aDto) {
        CTargetAddress connectionAddress = aDto.getConnectionAddress();
        IId tid = connectionAddress == null ? IId.INVALID : connectionAddress.getTID();
        return CConnectionDto.class.getSimpleName() + " ID=" + CUtilUuid.toShortString((UUID)aDto.getID()) + " Usage=" + (Object)((Object)aDto.getUsage()) + " Type=" + aDto.getType() + " TID=" + tid + " Local=" + aDto.getLocalAddress() + " Remote=" + aDto.getRemoteAddress();
    }
}

