/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.net.connection.printer;

import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.net.connection.printer.CWorkingTarget;
import de.sillysky.nyssr.impl.net.connection.printer.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CConnectionPrinterTarget
extends CTarget
implements IService {
    private static final String CONNECTION_STATUS = "connection status";
    private static final String HELP_CONNECTION_STATUS = "Print the connection status";
    private final IDependencies mDependencies;

    CConnectionPrinterTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace namespace = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.TRANSPORT);
        assert (namespace != null);
        namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.registerCli();
        return true;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (CONNECTION_STATUS.equals(command)) {
            aEnvelope.setBlocked(true);
            CWorkingTarget tgt = new CWorkingTarget(aEnvelope, aRecord);
            this.getTargetRegistry().registerTarget((ITarget)tgt);
        }
        return true;
    }

    private void registerCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{CONNECTION_STATUS});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{HELP_CONNECTION_STATUS});
        this.sendNotification(env, record);
    }
}

