/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Dimension;
import javax.swing.Box;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingBoxVerticalStrut
extends CSwingJComponent {
    private Box.Filler mComponent;

    CSwingBoxVerticalStrut(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.createComponent(aAttributes);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("height", this::applyHeight);
    }

    private void createComponent(@NotNull CJsonObject aAttributes) {
        Object o = aAttributes.getValue("height");
        int height = CUtilInteger.fromObject((Object)o, (int)10);
        this.mComponent = new Box.Filler(new Dimension(0, height), new Dimension(0, height), new Dimension(Short.MAX_VALUE, height));
    }

    private boolean applyHeight(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int height = CUtilInteger.fromObject((Object)aValue, (int)10);
            this.mComponent.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
            return true;
        }
        if (aValue instanceof String) {
            int height = CUtilInteger.fromObject((Object)aValue, (int)10);
            this.mComponent.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
            return true;
        }
        return false;
    }

    @NotNull
    public Box.Filler getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.BoxVerticalStrut.name();
    }
}

