/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu.CSwingMenu;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import javax.swing.JMenuBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingMenuBar
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingMenuBar.class);
    private final JMenuBar mComponent = new JMenuBar();

    public CSwingMenuBar(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("borderPainted", this::applyBorderPainted);
        list.addHandler("margin", this::applyMargin);
    }

    @Override
    public void addChildComponent(@NotNull CWidget aChild) {
        if (aChild instanceof CSwingMenu) {
            JMenuBar bar = this.getComponent();
            CSwingMenu m = (CSwingMenu)aChild;
            bar.add(m.getComponent());
        } else {
            super.addChildComponent(aChild);
        }
    }

    private boolean applyBorderPainted(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            LOG.debug("Set BorderPainted to {}", new Object[]{enabled});
            this.mComponent.setBorderPainted(enabled);
            return true;
        }
        return false;
    }

    private boolean applyMargin(@NotNull String aKey, @Nullable Object aValue) {
        CEventMargin event = CEventMargin.create((Object)aValue);
        if (event != null) {
            this.mComponent.setMargin(event.getMargin().toInsets());
            this.mComponent.invalidate();
            this.mComponent.repaint();
            return true;
        }
        return false;
    }

    @NotNull
    public JMenuBar getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.MenuBar.name();
    }
}

