/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.NotNull;

class CAbstractCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -9085096251117848311L;
    private final CTable mTable;

    public CAbstractCellRenderer(@NotNull CTable aTable) {
        this.mTable = aTable;
    }

    protected CTable getTable() {
        return this.mTable;
    }

    protected void handleBackground(@NotNull JComponent aComponent, @NotNull CCell aCell, boolean aIsSelected) {
        Color background = aIsSelected ? this.mTable.getSelectionBackground() : aCell.getTreeBackground();
        if (background != null) {
            aComponent.setBackground(background);
            aComponent.setOpaque(true);
        }
    }

    protected void handleForeground(@NotNull JComponent aComponent, @NotNull CCell aCell, boolean aIsSelected) {
        Color foreground = aIsSelected ? this.mTable.getSelectionForeground() : aCell.getTreeForeground();
        if (foreground != null) {
            aComponent.setForeground(foreground);
        }
    }

    protected void handleBorder(@NotNull JComponent aComponent, @NotNull CCell aCell, boolean aHasFocus) {
        Border border = aHasFocus ? this.mTable.getFocusBorder() : aCell.getTreeBorder();
        if (border != null) {
            aComponent.setBorder(border);
        } else {
            aComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
    }

    protected void handleFont(@NotNull JComponent aComponent, @NotNull CCell aCell) {
        Font font = aCell.getTreeFont();
        if (font != null) {
            aComponent.setFont(font);
        }
    }
}

