/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CSwingTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeader;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelAttributes;
import de.sillysky.nyssr.remoteskin.model.events.CEventOnTableCellNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTable
extends JTable {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"Table");
    private static final long serialVersionUID = -5486624231514763514L;
    private final CTableModel mModel;
    private final CTableHeader mTableHeader;
    private final CSwingTable mWidget;
    private Border mCellDefaultBorder;
    private Color mCellDefaultBackground;
    private Color mCellDefaultForeground;
    private Font mCellDefaultFont;
    private boolean mWantChange;

    CTable(@NotNull CSwingTable aWidget) {
        this.mWidget = aWidget;
        this.mModel = new CTableModel(this);
        this.setModel(this.mModel);
        this.setAutoCreateColumnsFromModel(false);
        this.mTableHeader = new CTableHeader(this);
        this.setTableHeader(this.mTableHeader);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    @NotNull
    CWidget getWidget() {
        return this.mWidget;
    }

    CTableModel getMyModel() {
        return this.mModel;
    }

    CTableHeader getMyTableHeader() {
        JTableHeader th = this.getTableHeader();
        return th == null ? null : this.mTableHeader;
    }

    void setWantChange(boolean aWantChange) {
        this.mWantChange = aWantChange;
    }

    void enableHeader(boolean aEnabled) {
        if (aEnabled) {
            this.setTableHeader(this.mTableHeader);
        } else {
            this.setTableHeader(null);
        }
    }

    void applyTableCell(@NotNull CEventTableCell aEvent) {
        String columnId = aEvent.getColumnId();
        String rowId = aEvent.getRowId();
        CEventLabelAttributes la = aEvent.getLabelAttributes();
        CTableModel model = this.getMyModel();
        CCell cell = model.getOrAddCell(columnId, rowId);
        if (cell != null) {
            IBorder border;
            CEventFont font;
            CEventColor fg;
            CEventColor bg;
            Boolean reset;
            String text = la.getDisplayedText();
            if (text != null) {
                cell.setValue(text);
            }
            if ((reset = aEvent.shallResetBefore()) != null && reset.booleanValue()) {
                cell.reset();
            }
            if ((bg = la.getBackground()) != null) {
                cell.setBackground(bg.createColor());
            }
            if ((fg = la.getForeground()) != null) {
                cell.setForeground(fg.createColor());
            }
            if ((font = la.getFont()) != null) {
                cell.setFont(font.createFont());
            }
            if ((border = la.getBorder()) != null) {
                cell.setBorder(border.createBorder());
            }
        }
    }

    void resetCells() {
        LOG.debug("Reset Cells");
        this.mModel.resetCells();
    }

    int getClickCountToEdit() {
        return 1;
    }

    @Nullable
    Border getCellDefaultBorder() {
        return this.mCellDefaultBorder;
    }

    void setCellDefaultBorder(@Nullable Border aBorder) {
        this.mCellDefaultBorder = aBorder;
    }

    @Nullable
    Color getCellDefaultBackground() {
        return this.mCellDefaultBackground;
    }

    void setCellDefaultBackground(@Nullable Color aColor) {
        this.mCellDefaultBackground = aColor;
    }

    @Nullable
    Color getCellDefaultForeground() {
        return this.mCellDefaultForeground;
    }

    void setCellDefaultForeground(@Nullable Color aColor) {
        this.mCellDefaultForeground = aColor;
    }

    @Nullable
    Font getCellDefaultFont() {
        return this.mCellDefaultFont;
    }

    void setCellDefaultFont(@Nullable Font aFont) {
        this.mCellDefaultFont = aFont;
    }

    void calcRowHeight() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            int rowHeight = this.getRowHeight(row);
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Component comp = this.prepareRenderer(this.getCellRenderer(row, col), row, col);
                TableColumn column = this.getColumnModel().getColumn(col);
                rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
                int colWidth = comp.getPreferredSize().width;
                column.setPreferredWidth(colWidth);
            }
            this.setRowHeight(row, rowHeight);
        }
    }

    public Border getFocusBorder() {
        Border outer = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border inner = BorderFactory.createDashedBorder(Color.LIGHT_GRAY);
        return BorderFactory.createCompoundBorder(outer, inner);
    }

    public void finish() {
        this.mModel.getColumnModel().finish();
    }

    public void fileArrived(String aRelativePath, Object aToken, ImageIcon aImage) {
        if (aToken instanceof Point) {
            Point point = (Point)aToken;
            if (point.y < 0) {
                this.mTableHeader.fileArrived(point.x, aImage);
            }
        }
    }

    void sendTableEvent(@NotNull CCell aCell) {
        if (this.mWantChange) {
            CEventOnTableCellNotification event = new CEventOnTableCellNotification(aCell.getColumnId(), aCell.getRowId(), aCell.getValueString());
            Object o = event.toJson();
            this.mWidget.addNotification("onTableChange", o);
            this.mWidget.sendNotification();
        }
    }
}

