/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingNode;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingTree;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CTreeNode;
import de.sillysky.nyssr.remoteskin.model.enums.ETreeSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeSelectionNotification;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTree
extends JTree
implements TreeSelectionListener {
    private final CSwingTree mSwingTree;

    CTree(CSwingTree aCSwingTree) {
        this.mSwingTree = aCSwingTree;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent aEvent) {
        if (this.mSwingTree.wantSelect()) {
            CEventTreeSelectionNotification event = new CEventTreeSelectionNotification();
            ETreeSelectionMode mode = this.getSelectionMode();
            event.setSelectionMode(mode);
            TreePath[] paths = this.getSelectionModel().getSelectionPaths();
            if (paths != null) {
                for (TreePath aPath : paths) {
                    this.addNodeToEvent(event, aPath.getLastPathComponent());
                }
            }
            this.mSwingTree.addNotification("onTreeSelect", event.toJson());
            this.mSwingTree.sendNotification();
        }
    }

    private void addNodeToEvent(@NotNull CEventTreeSelectionNotification aEvent, @Nullable Object aNode) {
        if (aNode instanceof CSwingNode) {
            CSwingNode node = (CSwingNode)aNode;
            CTreeNode myNode = node.getNode();
            aEvent.addSelection(new CEventTreeSelectionNotification.CEntry(myNode.getId(), myNode.getName(), node.isLeaf()));
        }
    }

    private ETreeSelectionMode getSelectionMode() {
        int mode = this.getSelectionModel().getSelectionMode();
        switch (mode) {
            case 2: {
                return ETreeSelectionMode.singleinterval;
            }
            case 4: {
                return ETreeSelectionMode.multipleintervals;
            }
        }
        return ETreeSelectionMode.single;
    }
}

