/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.server;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.tcp.server.CTargetForTcpServer;
import de.sillysky.nyssr.impl.tcp.server.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.tcp.ITcpConnection;
import de.sillysky.nyssr.tcp.ITcpConnectionOwner;
import de.sillysky.nyssr.tcp.ITcpServer;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTcpServer
implements Runnable,
ITcpServer,
ITcpConnectionOwner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpServer.class);
    private final AtomicBoolean mStop = new AtomicBoolean();
    private final CopyOnWriteArrayList<ITcpConnection> mConnections = new CopyOnWriteArrayList();
    private boolean mTlsEnabled = false;
    private String mTlsProtocols = "TLSv1.3";
    private String mTlsCipherSuites = "TLS_AES_128_GCM_SHA256";
    private int mPort = 0;
    private UUID mId;
    private boolean mRunning = false;
    private ServerSocket mServerSocket;
    private int mInputBufferSize = 270000;
    private CTargetForTcpServer mTarget;
    private IDependencies mDependencies;

    CTcpServer() {
    }

    void activateInstance(@NotNull IDependencies aDependencies, CStringProperties aProperties) throws Exception {
        this.mDependencies = aDependencies;
        LOG.debug("Activate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.setProperties(aProperties);
        this.mTarget = new CTargetForTcpServer();
        this.mTarget.activate(aDependencies, this);
        this.open();
    }

    @Override
    public void close() {
        this.mStop.set(true);
        if (!this.mServerSocket.isClosed()) {
            LOG.debug("Close socket on port {}.", new Object[]{this.mPort});
            try {
                this.mServerSocket.close();
                LOG.debug("Socket on port {} closed.", new Object[]{this.mPort});
            }
            catch (IOException e) {
                LOG.error("Exception on closing server socket on port {}.", this.mPort);
            }
        }
    }

    void deactivateInstance() {
        LOG.debug("Deactivate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.close();
        this.mTarget.deactivate();
        this.mTarget = null;
    }

    @Override
    public void deleteMe(ITcpConnection aConnection) {
        this.mConnections.remove(aConnection);
        this.mDependencies.getTcpConnectionFactory().deleteConnection(aConnection);
    }

    @Override
    @Nullable
    public UUID getConnectionID() {
        return null;
    }

    @Override
    public UUID getID() {
        return this.mId;
    }

    @Override
    public int getInputBufferSize() {
        return this.mInputBufferSize;
    }

    @Override
    public int getPort() {
        return this.mPort;
    }

    @Override
    @NotNull
    public String getStatus() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("TcpServer");
        int port = this.mServerSocket.getLocalPort();
        if (port != 0) {
            sb.append("[port=");
            sb.append(this.getPort());
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public boolean isTlsEnabled() {
        return this.mTlsEnabled;
    }

    @Override
    @NotNull
    public String getTlsProtocols() {
        return this.mTlsProtocols;
    }

    @Override
    @NotNull
    public String getTlsCipherSuites() {
        return this.mTlsCipherSuites;
    }

    private void open() throws Exception {
        LOG.info("Start: creating server socket on port {}.", new Object[]{this.mPort});
        if (this.mTlsEnabled) {
            SSLServerSocketFactory sslServerSocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            SSLServerSocket ss = (SSLServerSocket)sslServerSocketfactory.createServerSocket(this.mPort);
            @NotNull String[] protocols = CUtilStringArray.fromString((String)this.mTlsProtocols, (char)',');
            ss.setEnabledProtocols(protocols);
            @NotNull String[] cipherSuites = CUtilStringArray.fromString((String)this.mTlsCipherSuites, (char)',');
            ss.setEnabledCipherSuites(cipherSuites);
            this.mServerSocket = ss;
        } else {
            this.mServerSocket = new ServerSocket(this.mPort);
        }
        this.mStop.set(false);
        Thread thread = new Thread((Runnable)this, "TcpServer-" + this.mPort);
        thread.start();
        LOG.info("Okay: server socket created on port {}.", new Object[]{this.mPort});
    }

    @Override
    public void run() {
        this.mRunning = true;
        while (!this.mStop.get()) {
            try {
                Socket clientSocket = this.mServerSocket.accept();
                ITcpConnection connection = this.mDependencies.getTcpConnectionFactory().createConnection(this, clientSocket, this.mInputBufferSize, true);
                this.mConnections.add(connection);
            }
            catch (SocketException e) {
                LOG.debug("Okay: TCP Server closed on Port " + this.mPort);
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Exception on server accept or creating connection target.");
            }
        }
        this.mRunning = false;
    }

    private void setProperties(@NotNull CStringProperties aProperties) throws Exception {
        String value = aProperties.get("id", null);
        if (CUtilString.isValid((String)value)) {
            this.mId = CUtilUuid.fromString((String)value);
            if (CUtilUuid.isEmpty((UUID)this.mId)) {
                this.mId = CUtilUuid.random();
            }
        } else {
            this.mId = CUtilUuid.random();
        }
        if (CUtilString.isEmpty((String)(value = aProperties.get("port", null)))) {
            throw new CException(7).append("invalid port ").append(this.mPort);
        }
        this.mPort = Integer.parseInt(value);
        if (this.mPort <= 0) {
            throw new CException(7).append("invalid port ").append(this.mPort);
        }
        value = aProperties.get("tls.enabled", null);
        if (CUtilString.isValid((String)value)) {
            this.mTlsEnabled = Boolean.parseBoolean(value);
        }
        this.mTlsProtocols = aProperties.get("tls.protocols", "");
        this.mTlsCipherSuites = aProperties.get("tls.cipher.suites", "");
        value = aProperties.get("input.buffer.size", null);
        if (CUtilString.isValid((String)value)) {
            this.mInputBufferSize = Integer.parseInt(value);
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " " + CUtilUuid.toShortString((UUID)this.getID()) + " on port " + this.mPort;
    }
}

