/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.test;

import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationContext;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactory;
import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.app.test.CTestApp;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

final class CTestAppFactory
implements IApplicationFactory,
IService {
    private INameDb mNameDb;

    CTestAppFactory() {
    }

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IApplicationFactoryRegistry.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        IApplicationFactoryRegistry applicationFactoryRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getService(IApplicationFactoryRegistry.class);
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        if (applicationFactoryRegistry != null) {
            applicationFactoryRegistry.registerFactory((IApplicationFactory)this);
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        IApplicationFactoryRegistry applicationFactoryRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getService(IApplicationFactoryRegistry.class);
        if (applicationFactoryRegistry != null) {
            applicationFactoryRegistry.deregisterFactory((IApplicationFactory)this);
        }
    }

    public IApplicationDescription getApplicationDescription() {
        return CTestApp.mDesc;
    }

    public void notifyStopped(@NotNull UUID aInstanceId) {
    }

    @NotNull
    public IApplication start(@NotNull IApplicationContext aContext) throws CException {
        CTestApp app = new CTestApp();
        app.activate(this.mNameDb);
        app.start(aContext);
        return app;
    }

    public boolean stopSafely(@NotNull IApplication aApplication) throws Exception {
        boolean ok = aApplication.requestStop();
        if (ok) {
            aApplication.stop();
            aApplication.notifyStopped();
            return true;
        }
        return false;
    }
}

