/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.instance.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.app.EAppInstanceStatus;
import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.app.IApplicationInstanceRegistry;
import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.app.records.CRecordAppGetInstanceList;
import de.sillysky.nyssr.app.records.CRecordNotifyAppInstanceStopped;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.CUtilApplication;
import de.sillysky.nyssr.impl.app.instance.registry.CAppInstanceEntry;
import de.sillysky.nyssr.impl.app.instance.registry.CConstants;
import de.sillysky.nyssr.impl.app.instance.registry.IDependencies;
import de.sillysky.nyssr.impl.app.instance.registry.IInternalApplicationInstanceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.time.CUtilDuration;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CAppInstanceRegistry
extends CTarget
implements IApplicationInstanceRegistry,
IInternalApplicationInstanceRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAppInstanceRegistry.class);
    private final Map<UUID, CAppInstanceEntry> mAppInstances = new ConcurrentHashMap<UUID, CAppInstanceEntry>();
    private final LinkedList<CAppInstanceEntry> mStoppedAppInstances = new LinkedList();
    private final IDependencies mDependencies;
    private int mMaxStoppedInstances = 20;

    public CAppInstanceRegistry(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.privateReadConfiguration();
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAppGetInstanceList.ID, this::asyncGetAppInstanceList);
        this.addMessageHandler(CRecordNotifyAppInstanceStopped.ID, this::asyncNotifyAppInstanceStopped);
        INamespace ns = CUtilApplication.getOrCreateNamespace();
        ns.getTargetRegistry().registerTarget((ITarget)this, CConstants.TID);
        aServiceRegistry.registerService(IInternalApplicationInstanceRegistry.class, (Object)this);
        aServiceRegistry.registerService(IApplicationInstanceRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(this.getAddress(), "AppInstanceRegistry");
        this.mDependencies.getRecordHelper().addObserver(CRecordAppGetInstanceList.class, (ITarget)this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyAppInstanceStopped(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetAppInstanceList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord[] apps = this.getApplicationInstances();
        CRecordAppGetInstanceList.setAppInstanceList((CRecord)aRecord, (CRecord[])apps);
        aEnvelope.setResultSuccess();
        return true;
    }

    @NotNull
    public Collection<IApplicationInstance> getAll() {
        ArrayList<IApplicationInstance> list = new ArrayList<IApplicationInstance>();
        for (CAppInstanceEntry e : this.mAppInstances.values()) {
            list.add(e.getInstance());
        }
        return list;
    }

    @Nullable
    public IApplicationInstance getInstanceByID(@NotNull UUID aInstanceId) {
        CAppInstanceEntry entry = this.privateGetEntry(aInstanceId, true);
        if (entry != null) {
            return entry.getInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBeenRunAlready(@NotNull String aPresetName) {
        LinkedList<CAppInstanceEntry> linkedList = this.mStoppedAppInstances;
        synchronized (linkedList) {
            for (CAppInstanceEntry e : this.mStoppedAppInstances) {
                if (!e.getPresetName().equals(aPresetName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPaused(@NotNull UUID aInstanceId) {
        CAppInstanceEntry entry = this.privateCheckAndGet(aInstanceId);
        return entry.getInstance().getStatus() == EAppInstanceStatus.PAUSED;
    }

    public boolean isRunning(@NotNull String aPresetName) {
        for (CAppInstanceEntry e : this.mAppInstances.values()) {
            if (!e.getPresetName().equals(aPresetName)) continue;
            return true;
        }
        return false;
    }

    public IApplicationInstance pause(@NotNull UUID aInstanceId) {
        CAppInstanceEntry entry = this.privateCheckAndGet(aInstanceId);
        entry.getApplication().pause();
        entry.setStatus(EAppInstanceStatus.PAUSED);
        return entry.getInstance();
    }

    public IApplicationInstance resume(@NotNull UUID aInstanceId) {
        CAppInstanceEntry entry = this.privateCheckAndGet(aInstanceId);
        entry.getApplication().resume();
        entry.setStatus(EAppInstanceStatus.RUNNING);
        return entry.getInstance();
    }

    public void setProperty(@NotNull String aPresetName, @NotNull String aKey, String aValue) {
        this.mDependencies.getApplicationPresetRegistry().createProperty(aPresetName, aKey, aValue);
    }

    public IApplicationInstance registerInstance(@NotNull IApplicationDescription aDescription, @NotNull IApplicationPreset aPreset, @NotNull UUID aInstanceId, @NotNull IId aNID, @NotNull CNodeAddress aNode, @NotNull INamespace aNamespace, @Nullable CNodeAddress aRemoteSkinClientNode, @NotNull String aSessionToken, @NotNull String aUserId) {
        CAppInstanceEntry entry = new CAppInstanceEntry(aDescription, aPreset, aInstanceId, aNID, aNode, aNamespace, aRemoteSkinClientNode, aSessionToken, aUserId);
        this.mAppInstances.put(aInstanceId, entry);
        return entry.getInstance();
    }

    public void setApplication(@NotNull UUID aApplicationInstance, @Nullable IApplication aApplication) {
        CAppInstanceEntry entry = this.mAppInstances.get(aApplicationInstance);
        if (entry != null) {
            entry.setApplication(aApplication);
        }
    }

    private void setStatus(@NotNull UUID aInstanceId, @NotNull EAppInstanceStatus aStatus) {
        CAppInstanceEntry entry = this.privateGetEntry(aInstanceId, false);
        if (entry != null) {
            entry.setStatus(aStatus);
        }
    }

    @Override
    public void stopInstance(@NotNull UUID aInstanceId) {
        CAppInstanceEntry entry = this.mAppInstances.remove(aInstanceId);
        if (entry != null) {
            entry.setStatus(EAppInstanceStatus.STOPPED);
            this.privateAddStoppedInstance(entry);
        }
    }

    @Override
    @Nullable
    public CAppInstanceEntry getEntry(@NotNull UUID aInstanceId) {
        return this.privateGetEntry(aInstanceId, false);
    }

    @Nullable
    private CAppInstanceEntry privateGetEntry(@Nullable UUID aInstanceId, boolean aDoLog) {
        CAppInstanceEntry result = null;
        if (aInstanceId != null) {
            result = this.mAppInstances.get(aInstanceId);
        }
        if (result == null && aDoLog) {
            LOG.warn("No application instance found with that ID: {}", new Object[]{aInstanceId == null ? "null" : aInstanceId.toString()});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateAddStoppedInstance(@NotNull CAppInstanceEntry aInst) {
        LinkedList<CAppInstanceEntry> linkedList = this.mStoppedAppInstances;
        synchronized (linkedList) {
            this.mStoppedAppInstances.addLast(aInst);
            if (this.mMaxStoppedInstances > 0) {
                while (this.mStoppedAppInstances.size() > this.mMaxStoppedInstances) {
                    this.mStoppedAppInstances.removeFirst();
                }
            }
        }
    }

    private void privateReadConfiguration() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("application");
        preferences = preferences.node("instance");
        String str = preferences.get("maxSavedStoppedInstances", "50");
        this.mMaxStoppedInstances = CUtilInteger.fromString((String)str, (int)0);
    }

    private CAppInstanceEntry privateCheckAndGet(UUID aInstanceId) {
        CUtilCheck.checkNotNull((Object)aInstanceId, (String)"InstanceId is null", (Object[])new Object[0]);
        CAppInstanceEntry instance = this.mAppInstances.get(aInstanceId);
        CUtilCheck.checkNotNull((Object)instance, (String)"Instance %s not found", (Object[])new Object[]{aInstanceId.toString()});
        return instance;
    }

    public void dump() {
        StringBuilder sb = new StringBuilder(1000);
        if (LOG.isDebugEnabled()) {
            sb.append(CUtilString.LINE_CRLF);
            sb.append("* Applications running:\n");
            sb.append("* AppID   InstID  Name                          PresetName                    Running since\n");
            for (CAppInstanceEntry e : this.mAppInstances.values()) {
                sb.append(String.format("* %-8.8s", CUtilUuid.toShortString((UUID)e.getApplicationId())));
                sb.append(String.format("%-8.8s", CUtilUuid.toShortString((UUID)e.getInstanceId())));
                sb.append(String.format("%-30.30s", e.getApplicationName()));
                sb.append(String.format("%-30.30s", e.getPresetName()));
                LocalDateTime timeStarted = e.getTimeStarted();
                LocalDateTime now = LocalDateTime.now();
                Duration between = Duration.between(timeStarted, now);
                long millis = between.toMillis();
                String timeString = CUtilDuration.millisToShortDHMS((long)millis);
                sb.append(String.format("%s", timeString));
                sb.append(CUtilString.CRLF);
            }
            sb.append(CUtilString.LINE_CRLF);
            LOG.debug(sb.toString());
        }
    }

    @NotNull
    public List<UUID> getInstancesForNode(@NotNull CNodeAddress aNode) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (CAppInstanceEntry entry : this.mAppInstances.values()) {
            CNodeAddress remoteSkinClientNode = entry.getRemoteSkinClientNode();
            if (!aNode.equals((Object)remoteSkinClientNode)) continue;
            result.add(entry.getInstanceId());
        }
        return result;
    }

    private CRecord @NotNull [] getApplicationInstances() throws CException {
        ArrayList<CRecord> list = new ArrayList<CRecord>();
        for (IApplicationInstance entry : this.getAll()) {
            CRecord rec = entry.toRecord();
            list.add(rec);
        }
        CRecord[] arr = new CRecord[list.size()];
        arr = list.toArray(arr);
        return arr;
    }
}

