/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.app.manager.CApplicationManager;
import de.sillysky.nyssr.impl.app.manager.CUtilSession;
import de.sillysky.nyssr.impl.app.manager.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CAppStarterTarget
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAppStarterTarget.class);
    private final IDependencies mDependencies;
    private final CApplicationManager mManager;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;
    private final String mSessionToken;
    private final String mPresetName;
    private final String mRight;
    private final CNodeAddress mRemoteSkinClient;

    CAppStarterTarget(@NotNull IDependencies aDependencies, @NotNull CApplicationManager aManager, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, @NotNull String aSessionToken, @NotNull String aPresetName, @NotNull String aRight, @NotNull CNodeAddress aRemoteSkinClient) {
        this.mDependencies = aDependencies;
        this.mManager = aManager;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mSessionToken = aSessionToken;
        this.mPresetName = aPresetName;
        this.mRight = aRight;
        this.mRemoteSkinClient = aRemoteSkinClient;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncAnswerSessionValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CUtilSession.sendValidateToken(this, this.mSessionToken);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (!result.hasSuccess()) {
                this.mEnvelope.setResult(result);
            } else {
                String userId = CRecordSessionValidate.getUserId((CRecord)aRecord, null);
                String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                boolean allowed = CUtilSession.findRight(this.mRight, rights);
                if (allowed) {
                    try {
                        this.mManager.start(this.mEnvelope.getSender(), this.mRemoteSkinClient, this.mPresetName, this.mSessionToken, userId);
                        LOG.info("Preset {} started successfully by user {}", new Object[]{this.mPresetName, userId});
                        this.mEnvelope.setResultSuccess();
                    }
                    catch (CException aE) {
                        LOG.error((Throwable)aE, "Error starting preset {}", new Object[]{this.mPresetName});
                        this.mEnvelope.setResult(aE.getCode(), aE.getMessage());
                    }
                } else {
                    this.mEnvelope.setResult(5105, "Missing Rights");
                }
            }
            this.mEnvelope.setBlocked(false);
            this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
            this.deregisterTarget();
            return true;
        }
        return false;
    }
}

