/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.preset.target;

import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.app.records.CRecordAppAddPreset;
import de.sillysky.nyssr.app.records.CRecordAppChangePresetProperty;
import de.sillysky.nyssr.app.records.CRecordAppCreatePresetProperty;
import de.sillysky.nyssr.app.records.CRecordAppDeletePreset;
import de.sillysky.nyssr.app.records.CRecordAppDeletePresetProperty;
import de.sillysky.nyssr.app.records.CRecordAppGetPreset;
import de.sillysky.nyssr.app.records.CRecordAppGetPresetList;
import de.sillysky.nyssr.app.records.CRecordAppGetPresetListForUser;
import de.sillysky.nyssr.app.records.CRecordAppRenamePreset;
import de.sillysky.nyssr.app.records.CRecordDataApplicationPreset;
import de.sillysky.nyssr.app.records.CRecordDataRunnablePreset;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.CUtilApplication;
import de.sillysky.nyssr.impl.app.IApplicationPresetRegistry;
import de.sillysky.nyssr.impl.app.util.CSession;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTargetForPresetRegistry
extends CTarget
implements IService {
    private final Map<UUID, CMessage> mPendingMessages = new HashMap<UUID, CMessage>();
    private final Map<String, CSession> mSessions = new HashMap<String, CSession>();
    private IApplicationPresetRegistry mRegistry;
    private IRecordHelper mRecordHelper;
    private INameDb mNameDb;
    private IMicroServiceRegistryCollector mMicroServiceRegistryCollector;
    private IApplicationFactoryRegistry mAppFactoryRegistry;

    CTargetForPresetRegistry() {
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IApplicationPresetRegistry.class);
        aDependencyList.add(IApplicationFactoryRegistry.class);
        aDependencyList.add(IMicroServiceRegistryCollector.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
        this.mRegistry = (IApplicationPresetRegistry)aServiceRegistry.getServiceOrThrow(IApplicationPresetRegistry.class);
        this.mMicroServiceRegistryCollector = (IMicroServiceRegistryCollector)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistryCollector.class);
        this.mAppFactoryRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getServiceOrThrow(IApplicationFactoryRegistry.class);
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAppRenamePreset.ID, this::asyncRenamePreset);
        this.addMessageHandler(CRecordAppGetPreset.ID, this::asyncGetPreset);
        this.addMessageHandler(CRecordAppGetPresetList.ID, this::asyncGetPresetList);
        this.addMessageHandler(CRecordAppAddPreset.ID, this::asyncRegisterPreset);
        this.addMessageHandler(CRecordAppDeletePreset.ID, this::asyncDeregisterPreset);
        this.addMessageHandler(CRecordAppChangePresetProperty.ID, this::asyncChangeProperty);
        this.addMessageHandler(CRecordAppCreatePresetProperty.ID, this::asyncCreateProperty);
        this.addMessageHandler(CRecordAppDeletePresetProperty.ID, this::asyncDeleteProperty);
        this.addMessageHandler(CRecordAppGetPresetListForUser.ID, this::asyncGetPresetListForUser);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
        INamespace ns = CUtilApplication.getOrCreateNamespace();
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mNameDb.getTargetAddressDatabase().putName(this.getAddress(), "AppPresetReg");
        this.mRecordHelper.addObserver(CRecordAppRenamePreset.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppGetPreset.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppGetPresetList.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppAddPreset.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppDeletePreset.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppChangePresetProperty.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppCreatePresetProperty.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppDeletePresetProperty.class, (ITarget)this, false);
        this.mRecordHelper.addObserver(CRecordAppGetPresetListForUser.class, (ITarget)this, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetPresetListForUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String sessionToken = CRecordAppGetPresetListForUser.getSessionToken((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)sessionToken, (String)"Missing Session Token", (Object[])new Object[0]);
        CSession session = this.mSessions.get(sessionToken);
        if (session == null) {
            UUID transactionId = this.storeMessage(aEnvelope, aRecord);
            this.sendGetRights(transactionId, sessionToken);
        } else {
            this.getPresetListForUser(aRecord);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncChangeProperty(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        String presetName = CRecordAppChangePresetProperty.getPresetName((CRecord)aRecord, null);
        String propertyKey = CRecordAppChangePresetProperty.getPropertyKey((CRecord)aRecord, null);
        String propertyValue = CRecordAppChangePresetProperty.getPropertyValue((CRecord)aRecord, null);
        this.mRegistry.changeProperty(presetName, propertyKey, propertyValue);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCreateProperty(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        String presetName = CRecordAppCreatePresetProperty.getPresetName((CRecord)aRecord, null);
        String propertyKey = CRecordAppCreatePresetProperty.getPropertyKey((CRecord)aRecord, null);
        String propertyValue = CRecordAppCreatePresetProperty.getPropertyValue((CRecord)aRecord, null);
        this.mRegistry.createProperty(presetName, propertyKey, propertyValue);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeleteProperty(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        String presetName = CRecordAppDeletePresetProperty.getPresetName((CRecord)aRecord, null);
        String propertyKey = CRecordAppDeletePresetProperty.getPropertyKey((CRecord)aRecord, null);
        this.mRegistry.deleteProperty(presetName, propertyKey);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeregisterPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        String presetName = CRecordAppDeletePreset.getPresetName((CRecord)aRecord, null);
        boolean deleted = this.mRegistry.deletePreset(presetName);
        if (!deleted) {
            aEnvelope.setResult(5, "Not found");
        } else {
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String name = CRecordAppGetPreset.getPresetName((CRecord)aRecord, null);
        IApplicationPreset preset = this.mRegistry.getPresetByName(name);
        if (preset == null) {
            aEnvelope.setResult(5, "Not found");
        } else {
            CRecord rec = CRecordDataApplicationPreset.create();
            CRecordDataApplicationPreset.setPresetName((CRecord)rec, (String)preset.getPresetName());
            CRecordDataApplicationPreset.setApplicationId((CRecord)rec, (UUID)preset.getApplicationID());
            CRecordDataApplicationPreset.setProperties((CRecord)rec, (CStringProperties)preset.getProperties());
            CRecordAppGetPreset.setApplicationPreset((CRecord)aRecord, (CRecord)rec);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetPresetList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        Collection<IApplicationPreset> presets = this.mRegistry.getPresets();
        CRecord[] arr = new CRecord[presets.size()];
        int i = 0;
        for (IApplicationPreset p : presets) {
            CRecord rec = CRecordDataApplicationPreset.create();
            CRecordDataApplicationPreset.setPresetName((CRecord)rec, (String)p.getPresetName());
            CRecordDataApplicationPreset.setApplicationId((CRecord)rec, (UUID)p.getApplicationID());
            CRecordDataApplicationPreset.setProperties((CRecord)rec, (CStringProperties)p.getProperties());
            arr[i] = rec;
            ++i;
        }
        CRecordAppGetPresetList.setApplicationPresetList((CRecord)aRecord, (CRecord[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRegisterPreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws BackingStoreException {
        boolean createDefaultProperties;
        boolean added;
        CRecord recordPreset = CRecordAppAddPreset.getApplicationPreset((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)recordPreset, (String)"RecordPreset is null", (Object[])new Object[0]);
        String presetName = CRecordDataApplicationPreset.getPresetName((CRecord)recordPreset, null);
        CUtilCheck.checkEmptyString((Object)presetName, (String)"Missing Preset Name", (Object[])new Object[0]);
        UUID applicationID = CRecordDataApplicationPreset.getApplicationId((CRecord)recordPreset, null);
        CUtilCheck.checkNotNull((Object)applicationID, (String)"Missing Application ID", (Object[])new Object[0]);
        CStringProperties properties = CRecordDataApplicationPreset.getProperties((CRecord)recordPreset, null);
        if (properties == null) {
            properties = new CStringProperties();
        }
        if (!(added = this.mRegistry.addPreset(presetName, applicationID, properties, createDefaultProperties = CRecordAppAddPreset.getCreateDefaultProperties((CRecord)aRecord, (boolean)true)))) {
            aEnvelope.setResult(16, "Already registered");
        } else {
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncRenamePreset(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String oldPresetName = CRecordAppRenamePreset.getOldPresetName((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)oldPresetName, (String)"Old Preset Name missing", (Object[])new Object[0]);
        String newPresetName = CRecordAppRenamePreset.getNewPresetName((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)newPresetName, (String)"New Preset Name missing", (Object[])new Object[0]);
        this.mRegistry.renamePreset(oldPresetName, newPresetName);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String token = null;
            if (aEnvelope.getResultCode() == 0) {
                token = CRecordSessionValidate.getToken((CRecord)aRecord, null);
                String userId = CRecordSessionValidate.getUserId((CRecord)aRecord, null);
                String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                CSession session = new CSession(token, userId, rights);
                this.mSessions.put(token, session);
            }
            UUID transactionId = aEnvelope.getTransactionId();
            this.processPendingMessage(transactionId, token);
            return true;
        }
        return false;
    }

    private void sendGetRights(@NotNull UUID aTransactionId, @NotNull String aSessionToken) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setTransactionId(aTransactionId);
        CRecord record = CRecordSessionValidate.create();
        CRecordSessionValidate.setToken((CRecord)record, (String)aSessionToken);
        this.sendRequest(env, record);
    }

    private void getPresetListForUser(CRecord aRecord) {
    }

    private void processPendingMessage(@Nullable UUID aTransactionId, @Nullable String aToken) throws CException {
        CMessage msg;
        if (aTransactionId != null && (msg = this.mPendingMessages.remove(aTransactionId)) != null) {
            String[] rights;
            CSession session;
            boolean okay = false;
            CEnvelope env = msg.getEnvelope();
            if (aToken != null && (session = this.mSessions.get(aToken)) != null && (rights = session.getRights()) != null) {
                this.processPendingMessage(msg, session);
                okay = true;
            }
            if (!okay) {
                env.setResult(5105, "Missing Right");
            }
            env.setBlocked(false);
            this.getMessageSender().sendBack(msg);
        }
    }

    private void processPendingMessage(@NotNull CMessage aMsg, @NotNull CSession aSession) throws CException {
        CRecord record = aMsg.getRecord();
        IId id = record.getId();
        if (CRecordAppGetPresetListForUser.ID.equals((Object)id)) {
            ArrayList<CRecord> list = new ArrayList<CRecord>();
            Collection<IApplicationPreset> presets = this.mRegistry.getPresets();
            for (IApplicationPreset p : presets) {
                UUID applicationID;
                IApplicationDescription desc;
                CStringProperties properties = p.getProperties();
                String mandatoryRight = properties.get("mandatoryRight");
                if (!aSession.hasRight(mandatoryRight) || (desc = this.mAppFactoryRegistry.getDescriptionByID(applicationID = p.getApplicationID())) == null) continue;
                CRecord rec = this.fillRunnablePresetRecord(p, desc);
                list.add(rec);
            }
            CRecordAppGetPresetListForUser.setPresetList((CRecord)record, (CRecord[])list.toArray(new CRecord[0]));
        }
    }

    @NotNull
    private CRecord fillRunnablePresetRecord(@NotNull IApplicationPreset aPreset, @NotNull IApplicationDescription aAppDesc) throws CException {
        CRecord rec = CRecordDataRunnablePreset.create();
        CRecordDataRunnablePreset.setPresetName((CRecord)rec, (String)aPreset.getPresetName());
        CRecordDataRunnablePreset.setApplicationName((CRecord)rec, (String)aAppDesc.getName());
        CRecordDataRunnablePreset.setApplicationShortDescription((CRecord)rec, (String)aAppDesc.getShortDescription());
        CRecordDataRunnablePreset.setApplicationLongDescription((CRecord)rec, (String)aAppDesc.getLongDescription());
        CRecordDataRunnablePreset.setIconPath((CRecord)rec, (String)aAppDesc.getIconPath());
        return rec;
    }

    @NotNull
    private UUID storeMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        aEnvelope.setBlocked(true);
        CMessage msg = new CMessage(aEnvelope, aRecord);
        UUID transactionId = CUtilUuid.random();
        this.mPendingMessages.put(transactionId, msg);
        return transactionId;
    }
}

