/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.transport;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.transport.IPrivateTransport;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

final class CTransportOutputHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTransportOutputHandler.class);
    private static final ILogger LOG_PACKET = CLoggerFactory.getLogger((String)"network.packet");
    private static final ILogger LOG_MSG_TOTAL = CLoggerFactory.getLogger((String)"network.message.total");
    private final IPrivateTransport mTransport;
    private final Map<EPriority, Queue<IPacketMessage>> mPendingMessagePackets;
    private final EPacketType mDefaultMessageProtocol;
    private boolean mPacketOnTheWayToRemote = false;

    CTransportOutputHandler(IPrivateTransport aTransport) {
        this.mTransport = aTransport;
        this.mPendingMessagePackets = new HashMap<EPriority, Queue<IPacketMessage>>();
        this.mPendingMessagePackets.put(EPriority.LOW, new LinkedList());
        this.mPendingMessagePackets.put(EPriority.STREAM, new LinkedList());
        this.mPendingMessagePackets.put(EPriority.NORMAL, new LinkedList());
        this.mPendingMessagePackets.put(EPriority.HIGH, new LinkedList());
        Preferences preferences = aTransport.getDependencies().getKernelConfiguration().getPreferences("network");
        String s = preferences.get("message.protocol", "MESSAGE");
        LOG.info("raw Message Protocol is " + s);
        this.mDefaultMessageProtocol = (EPacketType)((Object)CUtilEnum.fromString(EPacketType.class, (String)s, (Object)((Object)EPacketType.MESSAGE)));
        LOG.info("Message Protocol is " + this.mDefaultMessageProtocol.name());
    }

    private IPacketMessage getNextPacket() {
        IPacketMessage packet = null;
        EPriority[] priorities = EPriority.values();
        for (int i = priorities.length - 1; i >= 0; --i) {
            EPriority priority = priorities[i];
            Queue<IPacketMessage> queue = this.mPendingMessagePackets.get(priority);
            if (queue.isEmpty()) continue;
            packet = queue.poll();
            break;
        }
        return packet;
    }

    void notifySendDone() {
        this.mPacketOnTheWayToRemote = false;
        this.sendNextPacket();
    }

    private void packMessage(CMessage aMessage) {
        IPacketFactory factory = this.mTransport.getPacketFactoryRegistry().getPacketFactory(this.mDefaultMessageProtocol);
        IPacket packet = factory.fromObject(aMessage);
        try {
            packet.pack();
            LOG_MSG_TOTAL.trace("MsgBytes = {}", new Object[]{packet.getPayload().length});
            this.storePacketInQueue((IPacketMessage)packet);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error on packing the message {}", new Object[]{aMessage});
        }
    }

    void prepareMessage(CMessage aMessage) throws CException {
        if (aMessage == null) {
            throw new CException(7).append("Message is null.");
        }
        CEnvelope env = aMessage.getEnvelope();
        CTargetAddress receiver = env.getReceiver();
        CNodeAddress remoteNode = receiver.getNodeAddress();
        IId destinationTid = receiver.getTID();
        if (!CNodeId.isValid((CNodeId)remoteNode.getNodeId()) && !CWellKnownTID.TRANSPORT.equals((Object)destinationTid)) {
            throw new CException(7).append("Node ID is empty.");
        }
        if (CNodeId.isValid((CNodeId)remoteNode.getNodeId())) {
            CNodeAddress localNode = this.mTransport.getLocalNode();
            if (localNode.equals((Object)remoteNode)) {
                throw new CException(7).append("Node ID is local, not remote.");
            }
            if (env.isRawTransport() || this.mTransport.canSendMessage(aMessage)) {
                this.packMessage(aMessage);
            }
        } else {
            this.packMessage(aMessage);
        }
        this.dump();
    }

    private void sendNextPacket() {
        IPacketMessage packet;
        if (!this.mPacketOnTheWayToRemote && (packet = this.getNextPacket()) != null) {
            this.mPacketOnTheWayToRemote = true;
            CNodeAddress source = packet.getSource();
            if (this.mTransport.getLocalNode().equals((Object)source)) {
                LOG_PACKET.trace("Out {}", new Object[]{packet});
            } else {
                LOG_PACKET.trace("Route {}", new Object[]{packet});
            }
            try {
                this.mTransport.sendPacketToTransportLayer(packet, true);
            }
            catch (CException e) {
                LOG.error("Error sending packet to transport layer: {}", new Object[]{packet.toString()});
                this.mPacketOnTheWayToRemote = false;
            }
        }
    }

    void storePacketInQueue(@NotNull IPacketMessage aPacket) {
        EPriority priority = aPacket.getPriority();
        Queue<IPacketMessage> queue = this.mPendingMessagePackets.get(priority);
        if (queue != null) {
            queue.offer(aPacket);
            this.sendNextPacket();
            this.dump();
        } else {
            LOG.error("Packet Priority is null");
        }
    }

    private void dump() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.getDump());
        }
    }

    @NotNull
    private String getDump() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(CUtilString.LINE_CRLF);
        sb.append("| Pending Messages for TCP\n");
        for (Map.Entry<EPriority, Queue<IPacketMessage>> e : this.mPendingMessagePackets.entrySet()) {
            sb.append("|     ").append(e.getKey()).append(": ").append(e.getValue().size()).append("\n");
        }
        sb.append(CUtilString.LINE_CRLF);
        return sb.toString();
    }
}

