/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.enums.EListBoxLayout;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventListBoxLayout
implements IRemoteSkinEvent {
    static final String KEY_LAYOUT = "layout";
    private static final EListBoxLayout DEFAULT_LAYOUT = EListBoxLayout.vertical;
    private final EListBoxLayout mLayout;

    public CEventListBoxLayout(@NotNull EListBoxLayout aLayout) {
        this.mLayout = aLayout;
    }

    @Nullable
    public static CEventListBoxLayout create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            return CEventListBoxLayout.convertString(jo.getValue(KEY_LAYOUT));
        }
        return CEventListBoxLayout.convertString(aValue);
    }

    @Nullable
    private static CEventListBoxLayout convertString(@Nullable Object aValue) {
        if (aValue instanceof String) {
            EListBoxLayout layout = (EListBoxLayout)((Object)CUtilEnum.fromString(EListBoxLayout.class, (String)((String)aValue), (Object)((Object)DEFAULT_LAYOUT)));
            return new CEventListBoxLayout(layout);
        }
        return new CEventListBoxLayout(DEFAULT_LAYOUT);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mLayout != DEFAULT_LAYOUT) {
            jo.put(KEY_LAYOUT, (Object)this.mLayout.name());
        }
        return jo;
    }

    public int getSwingConstant() {
        switch (this.mLayout) {
            case horizontalWrap: {
                return 2;
            }
            case verticalWrap: {
                return 1;
            }
        }
        return 0;
    }

    public EListBoxLayout getLayout() {
        return this.mLayout;
    }
}

