/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventEtchedBorder
implements IBorder,
IRemoteSkinEvent {
    private final Color mColorHighlight;
    private final Color mColorShadow;
    private final boolean mRaised;

    public CEventEtchedBorder(@NotNull Color aColorHighlight, @NotNull Color aColorShadow, boolean aRaised) {
        this.mColorHighlight = aColorHighlight;
        this.mColorShadow = aColorShadow;
        this.mRaised = aRaised;
    }

    @Nullable
    public static CEventEtchedBorder create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(EKeys.highlight.name());
            CEventColor dataHighlight = CEventColor.create(o);
            o = jo.getValue(EKeys.shadow.name());
            CEventColor dataShadow = CEventColor.create(o);
            boolean raised = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)EKeys.raised.name(), (boolean)true);
            if (dataHighlight != null && dataShadow != null) {
                return new CEventEtchedBorder(dataHighlight.createColor(), dataShadow.createColor(), raised);
            }
        }
        return null;
    }

    public Color getColorHighlight() {
        return this.mColorHighlight;
    }

    public Color getColorShadow() {
        return this.mColorShadow;
    }

    public boolean isRaised() {
        return this.mRaised;
    }

    @Override
    public Border createBorder() {
        return BorderFactory.createEtchedBorder(this.mRaised ? 0 : 1, this.mColorHighlight, this.mColorShadow);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        jo.put(EKeys.highlight.name(), new CEventColor(this.mColorHighlight).toJson());
        jo.put(EKeys.shadow.name(), new CEventColor(this.mColorShadow).toJson());
        jo.put(EKeys.raised.name(), (Object)this.mRaised);
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.etched;
    }

    public static enum EKeys {
        border_type,
        highlight,
        shadow,
        raised;

    }
}

