/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.layout;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonDouble;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.enums.EPosition;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.GridBagConstraints;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventLayoutConstraints
implements IRemoteSkinEvent {
    static final String KEY_INDEX = "index";
    static final String KEY_STRING = "string";
    static final String KEY_GRID_X = "gridx";
    static final String KEY_GRID_Y = "gridy";
    static final String KEY_IPAD_X = "ipadx";
    static final String KEY_IPAD_Y = "ipady";
    static final String KEY_GRID_WIDTH = "gridwidth";
    static final String KEY_GRID_HEIGHT = "gridheight";
    static final String KEY_WEIGHT_X = "weightx";
    static final String KEY_WEIGHT_Y = "weighty";
    static final String KEY_ANCHOR = "anchor";
    static final String KEY_FILL = "fill";
    static final String KEY_INSETS = "insets";
    static final String KEY_POSITION = "position";
    static final int DEFAULT_INDEX = -1;
    static final int DEFAULT_GRID_X = -1;
    static final int DEFAULT_GRID_Y = -1;
    static final int DEFAULT_IPAD_X = 0;
    static final int DEFAULT_IPAD_Y = 0;
    static final int DEFAULT_GRID_WIDTH = 1;
    static final int DEFAULT_GRID_HEIGHT = 1;
    static final int DEFAULT_FILL = 0;
    static final int DEFAULT_ANCHOR = 10;
    static final double MIN_WEIGHT = 1.0E-7;
    private int mIndex = -1;
    private GridBagConstraints mGridBagConstraints;
    private String mString;

    @Nullable
    public static CEventLayoutConstraints create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            GridBagConstraints c;
            CJsonObject jo = (CJsonObject)aValue;
            CEventLayoutConstraints event = new CEventLayoutConstraints();
            Object o = jo.getValue(KEY_INDEX);
            if (o != null) {
                int index = CUtilInteger.fromObject((Object)o, (int)-1);
                event.setIndex(index);
            }
            if ((o = jo.getValue(KEY_STRING)) instanceof String) {
                String s = CEventLayoutConstraints.checkPosition((String)o);
                event.setMigLayoutConstraints(s);
            }
            if ((o = jo.getValue(KEY_POSITION)) instanceof String) {
                EPosition position = (EPosition)((Object)CUtilEnum.fromString(EPosition.class, (String)((String)o), null));
                event.setPosition(position);
            }
            if ((c = CEventLayoutConstraints.readGridBagConstraints(jo)) != null) {
                event.setGridBagConstraints(c);
            }
            return event;
        }
        if (aValue instanceof String) {
            String s = CEventLayoutConstraints.checkPosition((String)aValue);
            CEventLayoutConstraints event = new CEventLayoutConstraints();
            event.setString(s);
            return event;
        }
        return null;
    }

    private static String checkPosition(@NotNull String aValue) {
        EPosition position = (EPosition)((Object)CUtilEnum.fromString(EPosition.class, (String)aValue, null));
        if (position != null) {
            return position.getSwingConstant();
        }
        return aValue;
    }

    @Nullable
    private static GridBagConstraints readGridBagConstraints(@NotNull CJsonObject aJo) {
        GridBagConstraints c = new GridBagConstraints();
        boolean changes = false;
        Object o = aJo.getValue(KEY_GRID_X);
        if (o != null) {
            changes = true;
            c.gridx = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_GRID_X, (int)-1);
        }
        if ((o = aJo.getValue(KEY_GRID_Y)) != null) {
            changes = true;
            c.gridy = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_GRID_Y, (int)-1);
        }
        if ((o = aJo.getValue(KEY_IPAD_X)) != null) {
            changes = true;
            c.ipadx = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_IPAD_X, (int)0);
        }
        if ((o = aJo.getValue(KEY_IPAD_Y)) != null) {
            changes = true;
            c.ipady = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_IPAD_Y, (int)0);
        }
        if ((o = aJo.getValue(KEY_GRID_WIDTH)) != null) {
            changes = true;
            c.gridwidth = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_GRID_WIDTH, (int)1);
        }
        if ((o = aJo.getValue(KEY_GRID_HEIGHT)) != null) {
            changes = true;
            c.gridheight = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_GRID_HEIGHT, (int)1);
        }
        if ((o = aJo.getValue(KEY_WEIGHT_X)) != null) {
            changes = true;
            c.weightx = CUtilJsonDouble.fromJson((CJsonObject)aJo, (String)KEY_WEIGHT_X, (double)c.weightx);
        }
        if ((o = aJo.getValue(KEY_WEIGHT_Y)) != null) {
            changes = true;
            c.weighty = CUtilJsonDouble.fromJson((CJsonObject)aJo, (String)KEY_WEIGHT_Y, (double)c.weighty);
        }
        if ((o = aJo.getValue(KEY_ANCHOR)) != null) {
            changes = true;
            c.anchor = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_ANCHOR, (int)10);
        }
        if ((o = aJo.getValue(KEY_FILL)) != null) {
            changes = true;
            c.fill = CUtilJsonInteger.fromJson((CJsonObject)aJo, (String)KEY_FILL, (int)0);
        }
        if ((o = aJo.getValue(KEY_INSETS)) != null) {
            changes = true;
            CEventMargin eventMargin = CEventMargin.create(o);
            if (eventMargin != null) {
                c.insets = eventMargin.getMargin().toInsets();
            }
        }
        return changes ? c : null;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIndex(int aIndex) {
        this.mIndex = aIndex;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mIndex >= 0) {
            jo.put(KEY_INDEX, (Object)this.mIndex);
        }
        if (CUtilString.isValid((String)this.mString)) {
            jo.put(KEY_STRING, (Object)this.mString);
        }
        if (this.mGridBagConstraints != null) {
            if (this.mGridBagConstraints.gridx != -1) {
                jo.put(KEY_GRID_X, (Object)this.mGridBagConstraints.gridx);
            }
            if (this.mGridBagConstraints.gridx != -1) {
                jo.put(KEY_GRID_Y, (Object)this.mGridBagConstraints.gridy);
            }
            if (this.mGridBagConstraints.gridwidth != 1) {
                jo.put(KEY_GRID_WIDTH, (Object)this.mGridBagConstraints.gridwidth);
            }
            if (this.mGridBagConstraints.gridheight != 1) {
                jo.put(KEY_GRID_HEIGHT, (Object)this.mGridBagConstraints.gridheight);
            }
            if (this.mGridBagConstraints.ipadx != 0) {
                jo.put(KEY_IPAD_X, (Object)this.mGridBagConstraints.ipadx);
            }
            if (this.mGridBagConstraints.ipady != 0) {
                jo.put(KEY_IPAD_Y, (Object)this.mGridBagConstraints.ipady);
            }
            if (this.mGridBagConstraints.fill != 0) {
                jo.put(KEY_FILL, (Object)this.mGridBagConstraints.fill);
            }
            if (this.mGridBagConstraints.anchor != 10) {
                jo.put(KEY_ANCHOR, (Object)this.mGridBagConstraints.anchor);
            }
            if (this.mGridBagConstraints.weightx >= 1.0E-7) {
                jo.put(KEY_WEIGHT_X, (Object)this.mGridBagConstraints.weightx);
            }
            if (this.mGridBagConstraints.weighty >= 1.0E-7) {
                jo.put(KEY_WEIGHT_Y, (Object)this.mGridBagConstraints.weighty);
            }
            if (this.mGridBagConstraints.insets.bottom != 0 || this.mGridBagConstraints.insets.top != 0 || this.mGridBagConstraints.insets.left != 0 || this.mGridBagConstraints.insets.right != 0) {
                jo.put(KEY_INSETS, new CEventMargin(this.mGridBagConstraints.insets.top, this.mGridBagConstraints.insets.left, this.mGridBagConstraints.insets.bottom, this.mGridBagConstraints.insets.right).toJson());
            }
        }
        return jo;
    }

    public void setPosition(EPosition aPosition) {
        this.mString = aPosition.name();
    }

    public void setMigLayoutConstraints(String aMigLayoutConstraints) {
        this.mString = aMigLayoutConstraints;
    }

    public void setGridBagConstraints(GridBagConstraints aGridBagConstraints) {
        this.mGridBagConstraints = aGridBagConstraints;
    }

    @Nullable
    public Object getConstraints() {
        if (this.mGridBagConstraints != null) {
            return this.mGridBagConstraints;
        }
        if (this.mString != null) {
            return this.mString;
        }
        return null;
    }

    private void setString(@NotNull String aString) {
        this.mString = aString;
    }
}

