/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.session.manager.ILocalService;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class CSessionEntry {
    private final String mToken;
    private final String mUserId;
    private final Collection<String> mRights;
    private final ILocalService mLocalService;
    private ZonedDateTime mTimeStamp;

    @NotNull
    static CSessionEntry fromStream(@NotNull ILocalService aLocalService, @NotNull DataInputStream aStream) throws IOException, CException {
        String token = CUtilString.fromStream((DataInput)aStream);
        String userId = CUtilString.fromStream((DataInput)aStream);
        @NotNull String[] rights = CUtilStringArray.fromStream((DataInput)aStream);
        ZonedDateTime timestamp = CUtilZonedDateTime.fromStream((DataInput)aStream);
        if (token == null || userId == null || rights == null || timestamp == null) {
            throw new CException(6);
        }
        return new CSessionEntry(aLocalService, token, userId, Arrays.asList(rights), timestamp);
    }

    CSessionEntry(@NotNull ILocalService aLocalService, @NotNull String aUserId, @NotNull Collection<String> aRights) {
        this.mLocalService = aLocalService;
        this.mToken = CUtilUuid.random().toString();
        this.mUserId = aUserId;
        this.mRights = aRights;
        this.mTimeStamp = ZonedDateTime.now();
    }

    CSessionEntry(@NotNull ILocalService aLocalService, @NotNull String aToken, @NotNull String aUserId, @NotNull Collection<String> aRights, @NotNull ZonedDateTime aTimeStamp) {
        this.mLocalService = aLocalService;
        this.mToken = aToken;
        this.mUserId = aUserId;
        this.mRights = aRights;
        this.mTimeStamp = aTimeStamp;
    }

    String getToken() {
        return this.mToken;
    }

    String getUserId() {
        return this.mUserId;
    }

    boolean hasRight(@NotNull String aRight) {
        for (String role : this.mRights) {
            if (!role.equals(aRight)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mUserId;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSessionEntry that = (CSessionEntry)aO;
        return this.mToken.equals(that.mToken);
    }

    public int hashCode() {
        return Objects.hash(this.mToken);
    }

    ZonedDateTime getTimeStamp() {
        return this.mTimeStamp;
    }

    void notifyActivity() {
        this.mTimeStamp = ZonedDateTime.now();
    }

    boolean isExpired() {
        return this.mTimeStamp.isBefore(ZonedDateTime.now().minusMinutes(this.mLocalService.getTimeoutInMinutes()));
    }

    public void toStream(@NotNull DataOutputStream aStream) throws IOException {
        CUtilString.toStream((DataOutput)aStream, (String)this.mToken);
        CUtilString.toStream((DataOutput)aStream, (String)this.mUserId);
        CUtilStringArray.toStream((DataOutput)aStream, (String[])this.mRights.toArray(new String[0]));
        CUtilZonedDateTime.toStream((DataOutput)aStream, (ZonedDateTime)this.mTimeStamp);
    }
}

