/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.node.list;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.network.node.list.CNodeListModel;
import de.sillysky.nyssr.impl.network.node.list.CNodeListUi;
import de.sillysky.nyssr.impl.network.node.list.IDependencies;
import de.sillysky.nyssr.impl.network.node.list.records.CRecordUpdateDialogNodeList;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.node.list.records.CRecordNodeListNodeChosen;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialog;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CDialogNodeListTarget
extends CBasicDialog {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.nodelist");
    private static final String[] JSON = new String[]{"/json/200_ChooseNode.json", "/json/201_PopupNode.json", "/json/202_NodeDescription.json"};
    private final CNodeListModel mModel;
    private CNodeListUi mUi;

    public CDialogNodeListTarget(@NotNull IDependencies aDependencies, @NotNull CDialogDto aDialogDto, @NotNull String aJsonName, @NotNull CRecord[] aLocalNodes) {
        super(aDependencies.getNamespaceRegistry(), aDependencies.getServerContextFactory(), aDependencies.getWidgetSetLoader(), aDialogDto);
        this.mModel = new CNodeListModel(aDependencies, this, aDialogDto, aJsonName);
        this.mModel.addNodes(aLocalNodes);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordUpdateDialogNodeList.ID, this::asyncUpdate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Start NodeList Target");
        super.startTarget(aEnvelope, aRecord);
        this.mUi = new CNodeListUi(this.mModel);
        this.mUi.mountWidgetSet200();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncUpdate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord[] records = CRecordUpdateDialogNodeList.getNodes(aRecord, null);
        this.mModel.addNodes(records);
        this.updateUi();
        aEnvelope.setResultSuccess();
        return true;
    }

    private void updateUi() {
        String filter = this.mModel.getFilter();
        CNodeAddress nodeAddress = this.mModel.getSelectedNodeAddress();
        CNodeInfo nodeInfo = this.mModel.getNodeInfo(nodeAddress);
        this.mUi.sendListContent(filter, nodeInfo);
    }

    void sendNodeId(@NotNull CNodeInfo aNodeInfo) throws CException {
        CDialogDto dto = this.mModel.getDialogDto();
        IRemoteSkinClientContext clientContext = dto.getClientContext();
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)dto.getOwnerAddress());
        CRecord record = CRecordNodeListNodeChosen.create();
        CRecordNodeListNodeChosen.setContextId((CRecord)record, (IId)clientContext.getId());
        CRecordNodeListNodeChosen.setPlatformType((CRecord)record, (String)clientContext.getPlatformType());
        CRecordNodeListNodeChosen.setWidgetSetId((CRecord)record, (CWidgetSetId)this.mModel.getWs200());
        CRecordNodeListNodeChosen.setNodeAddress((CRecord)record, (CNodeAddress)aNodeInfo.getNodeAddress());
        CRecordNodeListNodeChosen.setName((CRecord)record, (String)aNodeInfo.getName());
        CRecordNodeListNodeChosen.setDescription((CRecord)record, (String)aNodeInfo.getDescription());
        CRecordNodeListNodeChosen.setVendor((CRecord)record, (String)aNodeInfo.getVendor());
        CRecordNodeListNodeChosen.setLicenseId((CRecord)record, (UUID)aNodeInfo.getLicense());
        this.sendNotification(env, record);
    }

    protected String[] getJsonFiles() {
        return JSON;
    }
}

