/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.node.list;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.network.node.list.CDialogNodeListTarget;
import de.sillysky.nyssr.impl.network.node.list.IDependencies;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CNodeListModel {
    private static final AtomicInteger mNextInstance = new AtomicInteger(0);
    private final List<CNodeInfo> mNodes = new ArrayList<CNodeInfo>();
    private final String mJsonName;
    private final IDependencies mDependencies;
    private final CDialogDto mDialogDto;
    private final CDialogNodeListTarget mDialogTarget;
    private CNodeAddress mSelectedNodeAddress;
    private String mFilter = "";
    private CWidgetSetId mWs200;

    CNodeListModel(@NotNull IDependencies aDependencies, @NotNull CDialogNodeListTarget aDialogTarget, @NotNull CDialogDto aDialogDto, @NotNull String aJsonName) {
        this.mDependencies = aDependencies;
        this.mDialogTarget = aDialogTarget;
        this.mDialogDto = aDialogDto;
        this.mJsonName = aJsonName;
    }

    String getNextInstance() {
        return Integer.toString(mNextInstance.incrementAndGet());
    }

    CNodeAddress getSelectedNodeAddress() {
        return this.mSelectedNodeAddress;
    }

    void setSelectedNodeAddress(CNodeAddress aSelectedNodeAddress) {
        this.mSelectedNodeAddress = aSelectedNodeAddress;
    }

    String getFilter() {
        return this.mFilter;
    }

    void setFilter(String aFilter) {
        this.mFilter = aFilter;
    }

    public CWidgetSetId getWs200() {
        return this.mWs200;
    }

    public void setWs200(CWidgetSetId aWs200) {
        this.mWs200 = aWs200;
    }

    public String getJsonName() {
        return this.mJsonName;
    }

    public Collection<CNodeInfo> getNodes() {
        return this.mNodes;
    }

    public void clearNodes() {
        this.mNodes.clear();
    }

    public void addNode(@NotNull CNodeInfo aNode) {
        this.mNodes.add(aNode);
    }

    public void addNodes(@NotNull @NotNull CRecord @NotNull [] aRecords) {
        this.mNodes.clear();
        for (CRecord r : aRecords) {
            CNodeInfo info = CNodeInfo.create((CRecord)r);
            if (info == null) continue;
            this.mNodes.add(info);
        }
    }

    @Nullable
    public CNodeInfo getNodeInfo(@NotNull CNodeAddress aNodeAddress) {
        for (CNodeInfo node : this.mNodes) {
            if (!node.getNodeAddress().equals((Object)aNodeAddress)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public CNodeInfo getNodeInfo(@NotNull CNodeId aNodeId) {
        for (CNodeInfo node : this.mNodes) {
            if (!node.getNodeAddress().getNodeId().equals((Object)aNodeId)) continue;
            return node;
        }
        return null;
    }

    public IDependencies getDependencies() {
        return this.mDependencies;
    }

    public CDialogDto getDialogDto() {
        return this.mDialogDto;
    }

    public CDialogNodeListTarget getDialogTarget() {
        return this.mDialogTarget;
    }
}

