/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.panel;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMessagePanelInstanceModel {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.messagepanel");
    private static final String INVISIBLE_SPACE = "\u200b";
    private static final AtomicInteger mNextInstance = new AtomicInteger(0);
    private final CDialogDto mDialogDto;
    private final long mTimerDelay;
    private final String mEmptyMessage;
    private final List<String> mMessageHistory = new ArrayList<String>();
    private final List<String> mDisplayedText = new LinkedList<String>();
    private final CWidgetId mCenterAbove;
    private final Preferences mPreferences;
    private final int mPanelType;
    private long mTimerHandle = 0L;
    private boolean mHistoryVisible = false;
    private int mRows = 2;
    private Color mBackground;
    private Color mForeground;

    CMessagePanelInstanceModel(@NotNull CDialogDto aDialogDto, @Nullable CWidgetId aCenterAbove, @NotNull Preferences aPreferences, int aPanelType, boolean aHideOnNoMessage, long aTimerDelay) {
        this.mDialogDto = aDialogDto;
        this.mCenterAbove = aCenterAbove;
        this.mPreferences = aPreferences;
        this.mPanelType = aPanelType;
        if (this.mPanelType == 400) {
            this.mRows = 1;
        }
        this.mEmptyMessage = aHideOnNoMessage ? "" : INVISIBLE_SPACE;
        this.mTimerDelay = aTimerDelay;
    }

    List<String> getMessageHistory() {
        return this.mMessageHistory;
    }

    List<String> getDisplayedText() {
        return this.mDisplayedText;
    }

    String getNextInstance() {
        return Integer.toString(mNextInstance.incrementAndGet());
    }

    void addMessage(@NotNull String aMessage) {
        if (!this.mEmptyMessage.equals(aMessage)) {
            LOG.debug("MessagePanel: {}", new Object[]{aMessage});
            this.mMessageHistory.add(aMessage);
        }
        if (!this.mDisplayedText.isEmpty()) {
            this.mDisplayedText.remove(0);
        }
        this.mDisplayedText.add(aMessage);
    }

    void addEmptyMessage() {
        this.addMessage(this.mEmptyMessage);
    }

    boolean isEmpty() {
        for (String s : this.mDisplayedText) {
            if (this.mEmptyMessage.equals(s)) continue;
            return false;
        }
        return true;
    }

    boolean isHistoryVisible() {
        return this.mHistoryVisible;
    }

    void setHistoryVisible(boolean aHistoryVisible) {
        this.mHistoryVisible = aHistoryVisible;
    }

    int getRows() {
        return this.mRows;
    }

    void setRows(int aRows) {
        this.mRows = aRows;
    }

    int getPanelType() {
        return this.mPanelType;
    }

    @NotNull
    CWidgetId getParentWidgetId() {
        return this.mDialogDto.getParentWidgetId();
    }

    long getTimerDelay() {
        return this.mTimerDelay;
    }

    long getTimerHandle() {
        return this.mTimerHandle;
    }

    void setTimerHandle(long aTimerHandle) {
        this.mTimerHandle = aTimerHandle;
    }

    boolean isTimerRunning() {
        return this.mTimerHandle != 0L;
    }

    @NotNull
    IRemoteSkinClientContext getClientContext() {
        return this.mDialogDto.getClientContext();
    }

    Preferences getPreferences() {
        return this.mPreferences;
    }

    public CWidgetId getCenterAbove() {
        return this.mCenterAbove;
    }

    public Color getBackground() {
        return this.mBackground;
    }

    public void setBackground(Color aBackground) {
        this.mBackground = aBackground;
    }

    public Color getForeground() {
        return this.mForeground;
    }

    public void setForeground(Color aForeground) {
        this.mForeground = aForeground;
    }

    @NotNull
    CDialogDto getDialogDto() {
        return this.mDialogDto;
    }
}

