/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingWindow;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import java.awt.Component;
import java.awt.Dialog;
import org.jetbrains.annotations.NotNull;

public abstract class CSwingDialog
extends CSwingWindow {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingDialog.class);
    private static final CIntegerToStringMap mModalityType = new CIntegerToStringMap("ModalityType");

    CSwingDialog(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("decorated", this::applyDecorated);
        list.addHandler("modalityType", this::applyModalityType);
        list.addHandler("resizable", this::applyResizable);
        list.addHandler("title", this::applyTitle);
        list.addHandler("visible", this::applyVisibleDialog);
    }

    private boolean applyDecorated(@NotNull String aKey, @NotNull Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Dialog) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, b});
            ((Dialog)component).setUndecorated(!b);
            return true;
        }
        return false;
    }

    private boolean applyModalityType(@NotNull String aKey, @NotNull Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Dialog && aValue instanceof String) {
            String value = (String)aValue;
            int ordinal = mModalityType.get(value, Dialog.ModalityType.APPLICATION_MODAL.ordinal());
            Dialog.ModalityType m = Dialog.ModalityType.values()[ordinal];
            LOG.debug("Set {} to {}", new Object[]{aKey, m});
            ((Dialog)component).setModalityType(m);
            return true;
        }
        return false;
    }

    private boolean applyResizable(@NotNull String aKey, @NotNull Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Dialog) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, b});
            ((Dialog)component).setResizable(b);
            return true;
        }
        return false;
    }

    private boolean applyTitle(@NotNull String aKey, @NotNull Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Dialog && aValue instanceof String) {
            String value = (String)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, value});
            ((Dialog)component).setTitle(value);
            return true;
        }
        return false;
    }

    private boolean applyVisibleDialog(@NotNull String aKey, @NotNull Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Dialog) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, b});
            component.setVisible(b);
            return true;
        }
        return false;
    }

    static {
        mModalityType.add("APPLICATION_MODAL", Dialog.ModalityType.APPLICATION_MODAL.ordinal());
        mModalityType.add("DOCUMENT_MODAL", Dialog.ModalityType.DOCUMENT_MODAL.ordinal());
        mModalityType.add("MODELESS", Dialog.ModalityType.MODELESS.ordinal());
        mModalityType.add("TOOLKIT_MODAL", Dialog.ModalityType.TOOLKIT_MODAL.ordinal());
    }
}

