/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingTextComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventOnEnterNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventRectangle;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingTextField
extends CSwingTextComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingTextField.class);
    private final JTextField mComponent = new JTextField();
    private boolean mWantValueOnLeave;

    CSwingTextField(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("horizontalAlignment", this::applyHorizontalAlignment);
        list.addHandler("scrollOffset", this::applyScrollOffset);
        list.addHandler("scrollRectToVisible", this::applyScrollRectToVisible);
        list.addHandler("wantValueOnEnter", this::applyWantValueOnEnter);
        list.addHandler("widthInCharacters", this::applyWidthInCharacters);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.mComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (CSwingTextField.this.mWantValueOnLeave) {
                    String text = CSwingTextField.this.mComponent.getText();
                    CEventOnEnterNotification event = new CEventOnEnterNotification(text);
                    CSwingTextField.this.addNotification("onEnter", event.toJson());
                    CSwingTextField.this.sendNotification();
                }
            }
        });
    }

    private boolean applyHorizontalAlignment(@NotNull String aKey, @Nullable Object aValue) {
        CEventHorizontalAlignment event = CEventHorizontalAlignment.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getHorizontalAlignment()});
            int ha = event.getSwingConstant();
            this.getComponent().setHorizontalAlignment(ha);
            return true;
        }
        return false;
    }

    private boolean applyScrollOffset(@NotNull String aKey, @Nullable Object aValue) {
        int offset;
        if ((aValue instanceof Number || aValue instanceof String) && (offset = CUtilInteger.fromObject((Object)aValue, (int)-1)) >= 0) {
            this.mComponent.setScrollOffset(offset);
            return true;
        }
        return false;
    }

    private boolean applyScrollRectToVisible(@NotNull String aKey, @Nullable Object aValue) {
        CEventRectangle event = CEventRectangle.create((Object)aValue);
        if (event != null) {
            this.mComponent.scrollRectToVisible(event.getRectangle());
            return true;
        }
        return false;
    }

    private boolean applyWantValueOnEnter(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mWantValueOnLeave = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyWidthInCharacters(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int col = CUtilInteger.fromObject((Object)aValue, (int)10);
            LOG.debug("Set {} to {}", new Object[]{aKey, col});
            this.getComponent().setColumns(col);
            return true;
        }
        return false;
    }

    @NotNull
    public JTextField getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.TextField.name();
    }
}

