/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CRowModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableModel;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRow {
    private final CRowModel mRowModel;
    private final Map<String, CCell> mCells = new HashMap<String, CCell>();
    private String mId;
    private String mHeaderText;

    public CRow(@NotNull CRowModel aRowModel, @NotNull String aId) {
        this.mRowModel = aRowModel;
        this.mId = aId;
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    public void setId(@NotNull String aId) {
        this.mId = aId;
    }

    String getHeaderText() {
        return this.mHeaderText;
    }

    public void setHeaderText(String aHeaderText) {
        this.mHeaderText = aHeaderText;
    }

    public void addCell(@NotNull CCell aCell) {
        this.mCells.put(aCell.getColumnId(), aCell);
    }

    public CCell getCell(@NotNull String aColumnId) {
        return this.mCells.get(aColumnId);
    }

    @Nullable
    CCell getCellByIndex(int aColumnIndex) {
        CColumn column = this.mRowModel.getTableModel().getColumnModel().getColumnByIndex(aColumnIndex);
        if (column != null) {
            return this.mCells.get(column.getId());
        }
        return null;
    }

    @Nullable
    CCell getOrAddCellByIndex(int aColumnIndex) {
        CColumn column = this.mRowModel.getTableModel().getColumnModel().getColumnByIndex(aColumnIndex);
        if (column != null) {
            return this.getOrAddCell(column.getId());
        }
        return null;
    }

    @NotNull
    public CCell getOrAddCell(@NotNull String aColumnId) {
        CTableModel tableModel = this.mRowModel.getTableModel();
        tableModel.getColumnModel().getOrAddColumn(aColumnId);
        CCell cell = this.mCells.get(aColumnId);
        if (cell == null) {
            cell = new CCell(this.mRowModel, this.mId, aColumnId);
            this.addCell(cell);
        }
        return cell;
    }
}

