/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.database;

import de.sillysky.nyssr.database.IHandleResult;
import de.sillysky.nyssr.database.IPrepareStatement;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.time.stopwatch.CStopWatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CH2Table {
    private final ILogger mLogger;
    private final String mName;
    private final Connection mConnection;
    private final CStopWatch mWatch = new CStopWatch();

    protected CH2Table(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        this.mConnection = aConnection;
        this.mLogger = aLogger;
        this.mName = aName;
    }

    protected boolean existTable(@NotNull String aTableName) {
        try {
            ResultSet rs = this.mConnection.getMetaData().getTables("USERDB", "PUBLIC", aTableName, null);
            if (rs != null) {
                return rs.next();
            }
        }
        catch (SQLException aE) {
            aE.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T> T executeQuery(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep, @Nullable IHandleResult<T> aResultHandler) {
        block13: {
            this.mWatch.start();
            try {
                PreparedStatement statement = this.mConnection.prepareStatement(aSql);
                if (aPrep != null) {
                    aPrep.prepare(statement);
                }
                ResultSet rs = statement.executeQuery();
                if (aResultHandler == null) break block13;
                T t = aResultHandler.handleResult(rs);
                return t;
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.mLogger.error((Throwable)e, "Error {}.{}: ", new Object[]{this.mName, aName});
            }
            finally {
                this.mWatch.stop();
            }
        }
        return null;
    }

    protected long executeQueryLong(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        Long result = this.executeQuery(aSql, aName, aPrep, rs -> rs != null && rs.next() ? rs.getLong(1) : 0L);
        return result == null ? 0L : result;
    }

    @Nullable
    protected String executeQueryString(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        return this.executeQuery(aSql, aName, aPrep, rs -> rs.next() ? rs.getString(1) : null);
    }

    @Nullable
    protected List<String> executeQueryStringList(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        return this.executeQuery(aSql, aName, aPrep, rs -> {
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            return list;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(@NotNull String aSql, @NotNull String aName, @Nullable IPrepareStatement aPrep) {
        block13: {
            this.mWatch.start();
            try {
                int n;
                block12: {
                    PreparedStatement statement = this.mConnection.prepareStatement(aSql);
                    try {
                        if (aPrep != null) {
                            aPrep.prepare(statement);
                        }
                        n = statement.executeUpdate();
                        if (statement == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            this.mLogger.error((Throwable)e, "Error {}: ", new Object[]{aName});
                            break block13;
                        }
                    }
                    statement.close();
                }
                return n;
            }
            finally {
                this.mWatch.stop();
            }
        }
        return -1;
    }

    public void printStat(@NotNull ILogger aLogger) {
        aLogger.debug("Time used: {}: {} ns", new Object[]{this.mName, this.mWatch.getAccumulatedTime()});
    }

    public String createInClause(@NotNull Collection<String> aList) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("IN (");
        boolean once = false;
        for (String s : aList) {
            if (once) {
                sb.append(',');
            } else {
                once = true;
            }
            sb.append('\'');
            sb.append(s);
            sb.append('\'');
        }
        sb.append(')');
        return sb.toString();
    }
}

