/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.EShutDownMode;
import de.sillysky.nyssr.app.IApplicationFactory;
import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.app.records.CRecordAppStopApplication;
import de.sillysky.nyssr.app.records.CRecordNotifyAppInstanceStopped;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.instance.registry.CAppInstanceEntry;
import de.sillysky.nyssr.impl.app.manager.CUtilSession;
import de.sillysky.nyssr.impl.app.manager.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.util.CUtilEnum;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CUtilStopper {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilStopper.class);

    private CUtilStopper() {
    }

    private static void privateSendNotifyApplicationInstanceStopped(@NotNull CTarget aTarget, @NotNull CEnvelope aEnvelope, @NotNull IApplicationInstance aInstance, @Nullable CResult aResult) throws CException {
        aEnvelope.setSender(aTarget.getAddress());
        CRecord record = CRecordNotifyAppInstanceStopped.create();
        CRecord recordInstance = aInstance.toRecord();
        CRecordNotifyAppInstanceStopped.setInstance((CRecord)record, (CRecord)recordInstance);
        CRecordNotifyAppInstanceStopped.setResultCode((CRecord)record, (int)(aResult == null ? 0 : aResult.getCode()));
        CRecordNotifyAppInstanceStopped.setResultText((CRecord)record, (String)(aResult == null ? "" : aResult.getText()));
        aTarget.sendNotification(aEnvelope, record);
    }

    static void sendNotifyApplicationInstanceStopped(@NotNull CTarget aTarget, @NotNull IApplicationInstance aInstance, @Nullable CResult aResult) throws CException {
        CTargetAddress owner;
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNotifyAppInstanceStopped.class);
        CUtilStopper.privateSendNotifyApplicationInstanceStopped(aTarget, env, aInstance, aResult);
        String s = aInstance.getPresetProperties().get("owner.address", null);
        if (s != null && (owner = CTargetAddress.fromString((String)s)) != null && owner.isValid()) {
            CEnvelope env2 = CEnvelope.forSingleTarget((CTargetAddress)owner);
            CUtilStopper.privateSendNotifyApplicationInstanceStopped(aTarget, env2, aInstance, aResult);
        }
    }

    static EShutDownMode getShutDownMode(@NotNull CRecord aRecord) {
        String s = CRecordAppStopApplication.getShutdownMode((CRecord)aRecord, null);
        return (EShutDownMode)CUtilEnum.fromString(EShutDownMode.class, (String)s, (Object)EShutDownMode.SAFE);
    }

    static void stopViaFactory(@NotNull IDependencies aDependencies, @NotNull CAppInstanceEntry aEntry, @NotNull EShutDownMode aShutDownMode) throws Exception {
        UUID factoryId = aEntry.getApplicationId();
        IApplicationFactory factory = aDependencies.getApplicationFactoryRegistry().getFactory(factoryId);
        if (factory == null) {
            throw new CException(5).append("Couldn't find the application factory of instance ").append((Object)aEntry.getInstanceId());
        }
        boolean stopped = factory.stopSafely(aEntry.getApplication());
        if (aShutDownMode == EShutDownMode.SAFE && !stopped) {
            return;
        }
        factory.notifyStopped(aEntry.getInstanceId());
    }

    static void stopNamespace(@NotNull IDependencies aDependencies, @NotNull CAppInstanceEntry aEntry) throws CException {
        INamespace ns = aEntry.getNamespace();
        if (ns != null) {
            IId nid = ns.getNID();
            LOG.info("Stop Namespace {} of application {}", new Object[]{nid, aEntry});
            aDependencies.getNamespaceFactory().deleteNamespace(nid);
        }
    }

    static void informInstanceRegistry(@NotNull IDependencies aDependencies, @NotNull UUID aInstanceId) {
        aDependencies.getInternalApplicationInstanceRegistry().stopInstance(aInstanceId);
    }

    static void stopApplication(@NotNull IDependencies aDependencies, @NotNull CTarget aTarget, @NotNull CAppInstanceEntry aEntry, @NotNull EShutDownMode aShutDownMode, @NotNull ILogger aLogger, @NotNull String aUser) throws Exception {
        CUtilStopper.stopViaFactory(aDependencies, aEntry, aShutDownMode);
        CUtilStopper.stopNamespace(aDependencies, aEntry);
        CUtilStopper.informInstanceRegistry(aDependencies, aEntry.getInstanceId());
        aLogger.debug("Application instance removed: Type={}, instID={}, by User {}", new Object[]{aEntry.getApplicationId(), aEntry.getInstanceId(), aUser});
        CUtilStopper.sendNotifyApplicationInstanceStopped(aTarget, aEntry.getInstance(), new CResult());
        CUtilSession.logApps(aDependencies, aLogger, aEntry.getInstanceId(), aEntry.getNID(), aEntry.getInstance(), "stopped");
    }
}

