/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.preset;

import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactory;
import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.impl.app.IApplicationPresetRegistry;
import de.sillysky.nyssr.impl.app.preset.CApplicationPreset;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.IReadOnlyStringProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CApplicationPresetRegistry
implements IApplicationPresetRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CApplicationPresetRegistry.class);
    private final Map<String, CApplicationPreset> mPresets = new ConcurrentHashMap<String, CApplicationPreset>();
    private IApplicationFactoryRegistry mAppRegistry;
    private IKernelConfiguration mKernelConfiguration;

    CApplicationPresetRegistry() {
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IApplicationFactoryRegistry.class);
        aDependencyList.add(IKernelConfiguration.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getService(IKernelConfiguration.class);
        this.mAppRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getService(IApplicationFactoryRegistry.class);
        this.loadPresets();
        aServiceRegistry.registerService(IApplicationPresetRegistry.class, (Object)this);
    }

    @Override
    public boolean addPreset(@NotNull String aPresetName, @NotNull UUID aApplicationID, @Nullable CStringProperties aProperties, boolean aCreateDefaultProperties) throws BackingStoreException {
        CStringProperties sp = aProperties;
        if (sp == null) {
            sp = new CStringProperties();
        }
        if (aCreateDefaultProperties) {
            IApplicationFactory factory = this.mAppRegistry.getFactory(aApplicationID);
            if (factory == null) {
                LOG.warn("Could not save default Properties for Application {}", new Object[]{aApplicationID.toString()});
            } else {
                IApplicationDescription desc = factory.getApplicationDescription();
                CStringProperties defaultProperties = desc.getDefaultProperties();
                sp.addMissing(defaultProperties);
            }
        }
        CApplicationPreset preset = new CApplicationPreset(aPresetName, aApplicationID, aProperties);
        this.mPresets.put(aPresetName, preset);
        this.saveToDisk(preset);
        LOG.debug("Application preset {} registered", new Object[]{aPresetName});
        return true;
    }

    @Override
    public void changeProperty(@NotNull String aPresetName, @NotNull String aPropertyKey, @NotNull String aPropertyValue) {
        CApplicationPreset preset = this.mPresets.get(aPresetName);
        if (preset != null) {
            preset.getProperties().put(aPropertyKey, aPropertyValue);
            Preferences preferences = this.getPreferences(aPresetName);
            preferences.put(aPropertyKey, aPropertyValue);
        }
    }

    @Override
    public void createProperty(@NotNull String aPresetName, @NotNull String aPropertyKey, @NotNull String aPropertyValue) {
        this.changeProperty(aPresetName, aPropertyKey, aPropertyValue);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mPresets.clear();
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public boolean deletePreset(@NotNull String aPresetName) {
        CApplicationPreset preset = this.mPresets.remove(aPresetName);
        if (preset != null) {
            try {
                Preferences preferences = this.getPreferences(aPresetName);
                preferences.removeNode();
                this.flush();
            }
            catch (BackingStoreException e) {
                LOG.error((Throwable)e, "Error removing Preset {} from disk", new Object[]{aPresetName});
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteProperty(@NotNull String aPresetName, @NotNull String aPropertyKey) {
        CApplicationPreset preset = this.mPresets.get(aPresetName);
        if (preset != null) {
            Preferences preferences = this.getPreferences(aPresetName);
            preferences.remove(aPropertyKey);
            preset.removeProperty(aPropertyKey);
        }
    }

    @NotNull
    private Collection<String> getPreferenceNames() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Preferences preferences = this.mKernelConfiguration.getPreferences("application");
            preferences = preferences.node("preset");
            String[] strings = preferences.childrenNames();
            list.addAll(Arrays.asList(strings));
        }
        catch (BackingStoreException e) {
            LOG.error((Throwable)e, "Error reading Presets");
        }
        return list;
    }

    private Preferences getPreferences(String aPresetName) {
        Preferences preferences = this.mKernelConfiguration.getPreferences("application");
        preferences = preferences.node("preset");
        return preferences.node(aPresetName);
    }

    @Override
    public IApplicationPreset getPresetByName(@NotNull String aPresetName) {
        return this.mPresets.get(aPresetName);
    }

    @Override
    public int getPresetCount() {
        return this.mPresets.size();
    }

    @Override
    @NotNull
    public Collection<IApplicationPreset> getPresets() {
        return new ArrayList<IApplicationPreset>(this.mPresets.values());
    }

    private void loadPresets() {
        Preferences preferences = this.mKernelConfiguration.getPreferences("application");
        preferences = preferences.node("preset");
        Collection<String> presetNames = this.getPreferenceNames();
        for (String child : presetNames) {
            Preferences node = preferences.node(child);
            String value = node.get("application.id", "");
            UUID uuid = CUtilUuid.fromString((String)value);
            if (!CUtilUuid.isValid((UUID)uuid)) continue;
            CStringProperties sp = this.readProperties(child);
            CApplicationPreset p = new CApplicationPreset(child, uuid, sp);
            this.mPresets.put(p.getPresetName(), p);
        }
    }

    private CStringProperties readProperties(String aPresetName) {
        CStringProperties sp;
        try {
            Preferences node = this.getPreferences(aPresetName);
            sp = this.mKernelConfiguration.readProperties(node);
        }
        catch (BackingStoreException e) {
            LOG.error((Throwable)e, "Error reading Preset Properties");
            sp = new CStringProperties();
        }
        return sp;
    }

    private void removeSavedPreset(String aPresetName) throws BackingStoreException {
        Preferences presetPreferences = this.getPreferences(aPresetName);
        presetPreferences.removeNode();
        presetPreferences.flush();
    }

    @Override
    public void renamePreset(@NotNull String aOldPresetName, @NotNull String aNewPresetName) {
        try {
            CApplicationPreset newPreset = this.mPresets.get(aNewPresetName);
            if (newPreset != null) {
                LOG.error("Error renaming Preset; new Preset {} already exists", new Object[]{aNewPresetName});
                return;
            }
            CApplicationPreset oldPreset = this.mPresets.remove(aOldPresetName);
            if (oldPreset == null) {
                LOG.error("Error renaming Preset; {} doesn't exist", new Object[]{aOldPresetName});
                return;
            }
            newPreset = new CApplicationPreset(aNewPresetName, oldPreset.getApplicationID(), oldPreset.getProperties());
            this.mPresets.put(aNewPresetName, newPreset);
            this.saveToDisk(newPreset);
            this.removeSavedPreset(aOldPresetName);
        }
        catch (BackingStoreException e) {
            LOG.error((Throwable)e, "Error during removing Preset {}", new Object[]{aOldPresetName});
        }
    }

    @Override
    public void reset() {
        this.mPresets.clear();
        Preferences preferences = this.mKernelConfiguration.getPreferences("application");
        preferences = preferences.node("preset");
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        this.saveToDisk();
    }

    @Override
    public String getBackingStorePath() {
        Preferences preferences = this.mKernelConfiguration.getPreferences("application");
        preferences = preferences.node("preset");
        return preferences.absolutePath();
    }

    private void saveToDisk() throws BackingStoreException {
        for (CApplicationPreset p : this.mPresets.values()) {
            this.saveToDisk(p);
        }
    }

    private void saveToDisk(CApplicationPreset aPreset) throws BackingStoreException {
        String presetName = aPreset.getPresetName();
        Preferences presetPreferences = this.getPreferences(presetName);
        presetPreferences.put("application.id", aPreset.getApplicationID().toString());
        CStringProperties sp = aPreset.getProperties();
        if (sp != null) {
            CStringProperties newProp = sp.copy();
            CStringProperties oldProp = this.readProperties(presetName);
            newProp.getDoubles((IReadOnlyStringProperties)oldProp, true);
            CStringProperties work = newProp.getExisting((IReadOnlyStringProperties)oldProp, true, false);
            for (String key : work.getKeys()) {
                presetPreferences.put(key, work.get(key));
            }
            for (String key : newProp.getKeys()) {
                presetPreferences.put(key, newProp.get(key));
            }
        }
        presetPreferences.flush();
    }
}

