/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.database;

import de.sillysky.nyssr.file.store.common.CUtilFileStore;
import de.sillysky.nyssr.impl.file.store.database.CFileEntry;
import de.sillysky.nyssr.impl.file.store.database.CFileEntryList;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.files.CUtilFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.jetbrains.annotations.NotNull;

public class CDirectoryScanner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDirectoryScanner.class);
    private final Path mStorageDirectory;

    public CDirectoryScanner(@NotNull Path aStorageDirectory) {
        this.mStorageDirectory = aStorageDirectory;
    }

    public void scan(@NotNull CFileEntryList aList) {
        File dir = this.mStorageDirectory.toFile();
        if (dir.exists()) {
            LOG.debug("Scan directory {} for files.", new Object[]{dir});
            this.scan(dir, aList);
            LOG.debug("Okay: directory {} scanned.", new Object[]{dir});
        }
    }

    private void scan(@NotNull File aDir, @NotNull CFileEntryList aList) {
        File[] files = aDir.listFiles();
        if (files != null) {
            for (File f : files) {
                String fileName;
                String hash;
                if (f.isDirectory()) {
                    this.scan(f, aList);
                    continue;
                }
                if (f.getName().endsWith(".part")) {
                    f.delete();
                    continue;
                }
                Path pathFile = f.toPath();
                Path relativePath = this.mStorageDirectory.relativize(pathFile);
                String relativePathString = relativePath.toString();
                int i = relativePathString.lastIndexOf("._32_");
                if (i > 0) {
                    hash = relativePathString.substring(i + "._32_".length());
                    fileName = relativePathString.substring(0, i);
                } else {
                    hash = CUtilFileStore.calcHash(f);
                    fileName = relativePathString;
                }
                if (hash != null) {
                    FileTime[] timeStamps = CUtilFile.getFileTimes((File)f);
                    CFileEntry fe = new CFileEntry(hash, fileName, f, f.length(), timeStamps[0], timeStamps[1]);
                    aList.add(fe);
                    continue;
                }
                LOG.error("Can't calculate hash. Skip file {}.", new Object[]{f});
            }
        }
    }

    public String toString() {
        return this.mStorageDirectory.toString();
    }
}

