/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.webserver;

import com.sun.net.httpserver.HttpServer;
import de.sillysky.nyssr.impl.webserver.CStaticFileHandler;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

class CWebServer {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWebServer.class);
    private final int mPort;
    private final Path mWebRootPath;
    private HttpServer mServer;

    CWebServer(int aPort, @NotNull Path aWebRootPath) {
        this.mPort = aPort;
        this.mWebRootPath = aWebRootPath;
    }

    void start() throws IOException {
        this.mServer = HttpServer.create(new InetSocketAddress(this.mPort), 0);
        this.mServer.createContext("/", new CStaticFileHandler(this.mWebRootPath));
        this.mServer.setExecutor(null);
        this.mServer.start();
        LOG.info("Server started on port {}", new Object[]{this.mPort});
    }

    public void stop() {
        if (this.mServer != null) {
            this.mServer.stop(0);
        }
    }
}

