/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.software.updater.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordSetPluginList
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"55310d32-5724-4c36-a108-b03c0481b746");
    public static final String NAME = "SetPluginList";
    public static final String DESCRIPTION = "Set the library and plugin list of the node. Entries can have short names (json-simple), long names (json-simple-1.1.1), full names (json-simple-1.1.1.jar) or additional hash codes (json-simple-1.1.1.jar(XYNWCBXB3367HES79YHDNA9G6G)).";
    public static final String SLOT_LIBRARY_LIST = "2";
    public static final String SLOT_PLUGIN_LIST = "3";
    public static final String SLOT_PLUGIN_TO_LOAD_LIST = "4";
    public static final String SLOT_REBOOT = "5";
    public static final String SLOT_SESSION_TOKEN = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getLibraryList(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LIBRARY_LIST);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getPluginList(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PLUGIN_LIST);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getPluginToLoadList(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PLUGIN_TO_LOAD_LIST);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static boolean getReboot(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REBOOT);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setLibraryList(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_LIBRARY_LIST, slot);
    }

    public static void setPluginList(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_PLUGIN_LIST, slot);
    }

    public static void setPluginToLoadList(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_PLUGIN_TO_LOAD_LIST, slot);
    }

    public static void setReboot(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_REBOOT, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }
}

