/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.id;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.IIdFactory;
import de.sillysky.nyssr.id.integer.CPackageIdInteger;
import de.sillysky.nyssr.id.string.CPackageIdString;
import de.sillysky.nyssr.id.uuid.CPackageIdUuid;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.unique.integer.IUniqueInteger;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CIdFactory {
    public static final IId[] EMPTY_ARRAY = new IId[0];
    private static final ILogger LOG = CLoggerFactory.getLogger(CIdFactory.class);
    private static final Map<EIdType, IIdFactory> FACTORIES = new ConcurrentHashMap<EIdType, IIdFactory>(4);
    private static final int MAX_RANDOM_ID_ARRAY_LENGTH = 100;

    private CIdFactory() {
    }

    @NotNull
    public static IId getInvalid() {
        return IId.INVALID;
    }

    @NotNull
    public static IId randomOfType(@NotNull EIdType aType) {
        IId result = null;
        IIdFactory f = CIdFactory.getFactory(aType);
        if (f != null) {
            result = f.random();
        }
        return result == null ? IId.INVALID : result;
    }

    @NotNull
    public static IId fromObject(@NotNull EIdType aType, @NotNull Object aTemplate) {
        IId result = null;
        IIdFactory f = CIdFactory.getFactory(aType);
        if (f != null) {
            result = f.fromObject(aTemplate);
        }
        return result == null ? IId.INVALID : result;
    }

    @NotNull
    public static IId fromObject(@Nullable Object aId) {
        IId id = null;
        if (aId == null) {
            id = IId.INVALID;
        } else if (aId instanceof IId) {
            id = (IId)aId;
        } else {
            Collection<IIdFactory> values = FACTORIES.values();
            for (IIdFactory f : values) {
                if (f.getType() == EIdType.STRING || (id = f.fromObject(aId)) == null) continue;
                return id;
            }
            IIdFactory f = CIdFactory.getFactory(EIdType.STRING);
            if (f != null) {
                id = f.fromObject(aId);
            }
        }
        return id == null ? IId.INVALID : id;
    }

    public static IId @NotNull [] createArrayFromList(@Nullable List<?> aList) {
        if (aList == null || aList.isEmpty()) {
            return EMPTY_ARRAY;
        }
        ArrayList<IId> list = new ArrayList<IId>();
        for (Object element : aList) {
            IId id;
            if (element == null) continue;
            if (element instanceof IId) {
                id = (IId)element;
                list.add(id);
                continue;
            }
            if (element instanceof IId[]) {
                IId[] ids = (IId[])element;
                Collections.addAll(list, ids);
                continue;
            }
            id = CIdFactory.fromObject(element);
            list.add(id);
        }
        IId[] arr = new IId[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IId id;
            arr[i] = id = (IId)iterator.next();
            ++i;
        }
        return arr;
    }

    public static @NotNull IId @Nullable [] arrayFromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        IId[] array = new IId[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CIdFactory.fromStream(aStream, true);
        }
        return array;
    }

    @NotNull
    public static IId[] arrayFromString(@Nullable String aValue) {
        String[] stringArray = CUtilStringArray.fromString(aValue);
        return CIdFactory.arrayFromStringArray(stringArray);
    }

    @NotNull
    private static IId[] arrayFromStringArray(String @Nullable [] aList) {
        if (aList == null || aList.length == 0) {
            return EMPTY_ARRAY;
        }
        IId[] array = new IId[aList.length];
        int i = 0;
        for (String element : aList) {
            array[i] = CIdFactory.fromObject(element);
            ++i;
        }
        return array;
    }

    @NotNull
    public static IId random(@NotNull String aPrefix) {
        IId result = null;
        IUniqueInteger ui = CServiceRegistry.getInstance().getService(IUniqueInteger.class);
        IIdFactory f = CIdFactory.getFactory(EIdType.STRING);
        if (f != null) {
            if (ui != null) {
                String s = aPrefix + "-" + ui.getNext("StringId");
                result = f.fromObject(s);
            } else {
                result = f.random();
            }
        }
        return result == null ? IId.INVALID : result;
    }

    @NotNull
    public static IId random() {
        return CIdFactory.fromObject(EIdType.UUID, CUtilUuid.random());
    }

    @NotNull
    public static IId[] randomArray() {
        return CIdFactory.randomArray(CUtilRandom.getRandom().nextInt(100), false);
    }

    @NotNull
    public static IId[] randomArray(int aLength, boolean aWithNullValues) {
        int count = FACTORIES.size();
        if (count == 0) {
            return null;
        }
        EIdType[] typeArray = new EIdType[count];
        typeArray = FACTORIES.keySet().toArray(typeArray);
        IId[] array = new IId[aLength];
        for (int i = 0; i < aLength; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            int index = CUtilRandom.getRandom().nextInt(count);
            IIdFactory f = CIdFactory.getFactory(typeArray[index]);
            assert (f != null);
            array[i] = f.random();
        }
        return array;
    }

    public static boolean equals(@Nullable IId aId1, @Nullable IId aId2) {
        if (aId1 == aId2) {
            return true;
        }
        if (aId1 == null || aId2 == null) {
            return false;
        }
        return aId1.equals(aId2);
    }

    @Nullable
    public static IId fromStream(@NotNull DataInput aStream, boolean aCanBeNull) throws IOException {
        IIdFactory f;
        boolean valid;
        if (aCanBeNull && !(valid = aStream.readBoolean())) {
            return null;
        }
        byte b = aStream.readByte();
        EIdType type = EIdType.get(b);
        if (type != EIdType.INVALID && (f = CIdFactory.getFactory(type)) != null) {
            return f.fromStream(aStream);
        }
        return IId.INVALID;
    }

    @Nullable
    private static IIdFactory getFactory(@NotNull EIdType aType) {
        IIdFactory f = FACTORIES.get((Object)aType);
        if (f == null) {
            LOG.error("The ID factory {} has not been registered yet.", new Object[]{aType});
        }
        return f;
    }

    @NotNull
    public static IId getNonNullId(@Nullable IId aId) {
        if (aId == null) {
            return IId.INVALID;
        }
        return aId;
    }

    public static void initialize() {
        CPackageIdInteger.init();
        CPackageIdString.init();
        CPackageIdUuid.init();
    }

    public static boolean isArrayEqual(@NotNull IId[] aValue1, @NotNull IId[] aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        if (aValue2 == null) {
            return false;
        }
        for (int i = 0; i < aValue1.length; ++i) {
            if (CIdFactory.equals(aValue1[i], aValue2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(@Nullable IId aId) {
        return aId == null || !aId.isValid();
    }

    public static boolean isValid(@Nullable IId aId) {
        return aId != null && aId.isValid();
    }

    public static void registerFactory(@NotNull IIdFactory aFactory) {
        FACTORIES.put(aFactory.getType(), aFactory);
    }

    public static void arrayToStream(@NotNull DataOutput aStream, @Nullable @Nullable IId @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (IId element : aValue) {
                CIdFactory.toStream(aStream, element);
            }
        }
    }

    public static String writeArrayToString(IId @Nullable [] aValue) {
        String result = "";
        if (aValue != null && aValue.length > 0) {
            String[] arr = new String[aValue.length];
            for (int i = 0; i < aValue.length; ++i) {
                arr[i] = aValue[i] == null ? "" : aValue[i].valueToString();
            }
            result = CUtilStringArray.toStringWithPipe(arr);
        }
        return result;
    }

    public static void writeArrayToStringList(@Nullable IId[] aValue, @NotNull List<String> aList) {
        if (aValue != null && aValue.length > 0) {
            for (IId element : aValue) {
                String s = element == null ? "" : element.valueToString();
                aList.add(s);
            }
        }
    }

    public static int compareTo(@Nullable IId aId1, @Nullable IId aId2) {
        if (aId1 == aId2) {
            return 0;
        }
        if (aId1 == null) {
            return 1;
        }
        if (aId2 == null) {
            return -1;
        }
        return aId1.toString().compareTo(aId2.toString());
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable IId aId) throws IOException {
        if (aId == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            aId.toStream(aStream);
        }
    }

    public static IId @Nullable [] copy(IId @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    static {
        CIdFactory.initialize();
    }
}

