/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log.catcher;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.catcher.records.CRecordLog;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import org.jetbrains.annotations.NotNull;

public class CUtilLog {
    private CUtilLog() {
    }

    public static CRecord dtoToRecord(@NotNull CLogDto aEvent) throws CException {
        CRecord rec = CRecordLog.create();
        CRecordLog.setFormattedMessage(rec, aEvent.getFormattedText());
        CRecordLog.setLevel(rec, aEvent.getLevel().toString());
        String name = aEvent.getName();
        Class<?> loggerClass = aEvent.getLoggerClass();
        String loggerName = loggerClass == null ? name : loggerClass.getName();
        CRecordLog.setLoggerName(rec, loggerName);
        CRecordLog.setMessage(rec, aEvent.getMessage());
        CRecordLog.setThreadName(rec, aEvent.getThreadName());
        long millis = CUtilLocalDateTime.getLocalMillis(aEvent.getTimeStamp());
        CRecordLog.setTimeStamp(rec, millis);
        return rec;
    }
}

