/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.queue;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.queue.CMessageQueueRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.IPostMan;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import de.sillysky.nyssr.result.CResult;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

abstract class CAbstractMessageQueue
implements IMessageQueue {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAbstractMessageQueue.class);
    @NotNull
    private final CMessageQueueRegistry mRegistry;
    @NotNull
    private final IPostMan mPostMan;
    @NotNull
    private final IId mID;
    @NotNull
    private final String mDescription;
    @NotNull
    private final IMessageSender mMessageSender;

    CAbstractMessageQueue(@NotNull CMessageQueueRegistry aRegistry, @NotNull IMessageSender aMessageSender, @NotNull IId aQueueId, @NotNull String aDesc, @NotNull IPostMan aPostMan) {
        this.mRegistry = aRegistry;
        this.mMessageSender = aMessageSender;
        this.mID = aQueueId;
        this.mDescription = aDesc;
        this.mPostMan = aPostMan;
    }

    void call(CMessage aMsg) throws Exception {
        if (this.mPostMan != null) {
            this.mPostMan.deliverMessage(aMsg);
        }
    }

    void deregisterMe() {
        if (this.mRegistry != null) {
            try {
                if (this.mRegistry.getQueue(this.mID) == this) {
                    this.mRegistry.deleteQueue(this.getId());
                }
            }
            catch (Exception e) {
                int size = this.getSize();
                String text = e.getMessage();
                LOG.error(e, "Exception deregister queue: [Queue={}][QueueSize={}][Text={}] {}", this.mID, size, text);
            }
        }
    }

    void dispatchInternal(CMessage aMsg) {
        CEnvelope envelope = aMsg.getEnvelope();
        try {
            if (envelope.isAnswer()) {
                envelope.setTimeDeliverAnswer(Instant.now());
            } else {
                envelope.setTimeDeliver(Instant.now());
            }
            this.call(aMsg);
            this.sendBack(aMsg);
        }
        catch (CException e) {
            CResult err = e.getError();
            LOG.error((Throwable)e, "Uncaught exception in Queue: ");
            this.sendBackBecauseOfError(aMsg, err.getCode(), err.getText());
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Uncaught exception in Queue: ");
            this.sendBackBecauseOfError(aMsg, 2, e.getMessage());
        }
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CAbstractMessageQueue other = (CAbstractMessageQueue)aObj;
        return this.mID == other.mID;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @NotNull
    public IId getId() {
        return this.mID;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public int hashCode() {
        return 911 + this.mID.hashCode();
    }

    protected void sendBack(CMessage aMsg) throws Exception {
        if (aMsg.getEnvelope().shallForward()) {
            aMsg.getEnvelope().forwardMessage(null);
            this.mMessageSender.send(aMsg);
        } else {
            this.mMessageSender.sendBack(aMsg);
        }
    }

    private void sendBackBecauseOfError(CMessage aMsg, int aResultCode, String aResultText) {
        CEnvelope envelope = aMsg.getEnvelope();
        envelope.setBlocked(false);
        try {
            envelope.setResult(new CResult(aResultCode, aResultText));
            this.sendBack(aMsg);
        }
        catch (Exception e) {
            LOG.error(e, "Exception on sendBack, Msg={}", aMsg);
        }
    }
}

