/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilObjectArray;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.array.CUtilArray;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotZonedDateTimeArray
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final ZonedDateTime[] mValue;

    CSlotZonedDateTimeArray() {
        this.mValue = null;
    }

    private CSlotZonedDateTimeArray(ZonedDateTime[] aValue) {
        this.mValue = Arrays.copyOf(aValue, aValue.length);
    }

    @NotNull
    private static CSlotZonedDateTimeArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof ZonedDateTime[]) {
            return new CSlotZonedDateTimeArray((ZonedDateTime[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotZonedDateTimeArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotZonedDateTimeArray.fromList((List)aValue);
        }
        return new CSlotZonedDateTimeArray();
    }

    @NotNull
    private static CSlotZonedDateTimeArray fromList(@NotNull List<?> aValue) {
        if (aValue.isEmpty()) {
            return new CSlotZonedDateTimeArray();
        }
        ArrayList<ZonedDateTime> list = new ArrayList<ZonedDateTime>();
        for (Object element : aValue) {
            if (element == null) continue;
            if (element instanceof ZonedDateTime) {
                ZonedDateTime e = (ZonedDateTime)element;
                list.add(e);
                continue;
            }
            if (element instanceof ZonedDateTime[]) {
                ZonedDateTime[] ee = (ZonedDateTime[])element;
                list.addAll(Arrays.asList(ee));
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            ZonedDateTime ta = CUtilZonedDateTime.fromIsoString(s);
            list.add(ta);
        }
        ZonedDateTime[] arr = new ZonedDateTime[list.size()];
        int pos = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ZonedDateTime element;
            arr[pos] = element = (ZonedDateTime)iterator.next();
            ++pos;
        }
        return new CSlotZonedDateTimeArray(arr);
    }

    @NotNull
    private static CSlotZonedDateTimeArray fromStream(@NotNull DataInput aStream) throws IOException {
        @Nullable ZonedDateTime[] value = CUtilZonedDateTime.arrayFromStream(aStream);
        return new CSlotZonedDateTimeArray(value);
    }

    @NotNull
    private static CSlotZonedDateTimeArray fromString(String aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return new CSlotZonedDateTimeArray();
        }
        String[] result = CUtilStringArray.fromString(aValue);
        if (result == null || result.length == 0) {
            return new CSlotZonedDateTimeArray();
        }
        ZonedDateTime[] value = new ZonedDateTime[result.length];
        for (int i = 0; i < result.length; ++i) {
            value[i] = CUtilZonedDateTime.fromIsoString(result[i]);
        }
        return new CSlotZonedDateTimeArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotZonedDateTimeArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            ZonedDateTime[] values = new ZonedDateTime[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    values[i++] = CUtilZonedDateTime.fromIsoString((String)child);
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotZonedDateTimeArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotZonedDateTimeArray other = (CSlotZonedDateTimeArray)aObj;
        return Arrays.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return ZonedDateTime[].class;
    }

    @Override
    public ISlot copy() {
        return new CSlotZonedDateTimeArray(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.ZONED_DATE_TIME_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Objects.equals(this.mValue, aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotZonedDateTimeArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilZonedDateTime.arrayToStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilObjectArray.toString((Object[])this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue.length == 0) {
            return "";
        }
        return CUtilArray.toString(0, ',', 0, index -> index >= this.mValue.length ? "\uf00bE" : CUtilZonedDateTime.valueToString(this.mValue[index]));
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (ZonedDateTime time : this.mValue) {
                arr.add(time == null ? "" : CUtilZonedDateTime.valueToString(time));
            }
            return arr;
        }
        return null;
    }
}

