/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.nanoservice;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.nanoservice.CRecordDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IRecordIO;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CDescriptionOfRecord
implements Comparable<CDescriptionOfRecord>,
IRecordIO {
    @NotNull
    private final IId mId;
    @NotNull
    private final String mDescription;

    public CDescriptionOfRecord(@NotNull IId aId, @NotNull String aDescription) {
        this.mId = aId;
        this.mDescription = aDescription;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CDescriptionOfRecord fromRecord(@NotNull CRecord aRecord) throws CException {
        CUtilCheck.checkTrue(CRecordDescriptionOfRecord.ID.equals(aRecord.getId()), "Wrong Record ID", new Object[0]);
        IId id = CRecordDescriptionOfRecord.getId(aRecord, null);
        CUtilCheck.checkNotNullEx(id, "Empty ID", new Object[0]);
        String s = CRecordDescriptionOfRecord.getDescription(aRecord, "");
        String description = s == null ? "" : s;
        return new CDescriptionOfRecord(id, description);
    }

    @Override
    public int compareTo(@NotNull CDescriptionOfRecord aOther) {
        return this.mId.compareTo(aOther.mId);
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CDescriptionOfRecord that = (CDescriptionOfRecord)aO;
        return this.mId.equals(that.mId);
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @NotNull
    public IId getId() {
        return this.mId;
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public String toString() {
        return "{" + this.mId + " (" + this.mDescription + ")}";
    }

    @Override
    public CRecord valueToRecord() throws CException {
        CRecord rec = new CRecord(CRecordDescriptionOfRecord.ID);
        CRecordDescriptionOfRecord.setId(rec, this.mId);
        CRecordDescriptionOfRecord.setDescription(rec, this.mDescription);
        return rec;
    }
}

