/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.record;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.stopwatch.CStopWatch;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CRecordPrinter {
    static final AtomicReference<INameDb> NAME_DB = new AtomicReference<Object>(null);
    private static final AtomicReference<CStopWatch> WATCH = new AtomicReference<CStopWatch>(new CStopWatch());
    private static final String TAB = "    ";
    private final CRecord mRecord;
    private final StringBuilder mSb = new StringBuilder(1000);

    public CRecordPrinter(@NotNull CRecord aRecord) {
        this.mRecord = aRecord;
    }

    private void tab(@NotNull String aString) {
        this.mSb.append(TAB);
        this.mSb.append(aString);
    }

    private void newLine() {
        this.mSb.append(CUtilString.CRLF);
    }

    public String print() {
        CStopWatch watch = WATCH.get();
        watch.start();
        this.printHeader();
        this.newLine();
        this.printSlots();
        String s = this.mSb.toString();
        watch.stop();
        return s;
    }

    private void printSlots() {
        int size = this.mRecord.size();
        this.tab("SlotCount:   ");
        this.mSb.append(size);
        List sortedKeyList = this.mRecord.getKeys().stream().sorted().collect(Collectors.toList());
        if (size > 0) {
            for (String key : sortedKeyList) {
                this.printSlot(key);
            }
        }
    }

    private void printSlot(@NotNull String aKey) {
        this.newLine();
        this.tab("Slot ");
        this.mSb.append(String.format("%-8.8s", aKey));
        ISlot slot = this.mRecord.getSlot(aKey);
        if (slot == null) {
            this.mSb.append("null");
        } else {
            String typeName = slot.getType().getName();
            String s = String.format("%-20.20s  %s", typeName, slot);
            this.mSb.append(s);
        }
    }

    private void printHeader() {
        String name;
        this.mSb.append("Record ID = ");
        IId id = this.mRecord.getId();
        this.mSb.append(id);
        INameDb nameDb = NAME_DB.get();
        if (nameDb != null && (name = nameDb.getRecordIdDatabase().getNameOrNull(id)) != null) {
            this.mSb.append(" (");
            this.mSb.append(name);
            this.mSb.append(')');
        }
    }

    public String printShort() {
        this.printHeader();
        return this.mSb.toString();
    }
}

