/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CBitField;
import de.sillysky.nyssr.util.CUtilOS;
import de.sillysky.nyssr.util.files.CFileAttributes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CFileAttributeFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CFileAttributeFactory.class);

    private CFileAttributeFactory() {
    }

    @NotNull
    public static CFileAttributes createDirectoryFromStream(@NotNull DataInput aStream) throws IOException {
        CBitField bf = CBitField.fromStreamFixedLength(aStream);
        CFileAttributes attributes = new CFileAttributes(bf);
        long val = aStream.readLong();
        attributes.setTimeOfCreation(val);
        val = aStream.readLong();
        attributes.setTimeOfLastAccess(val);
        val = aStream.readLong();
        attributes.setTimeOfLastModification(val);
        return attributes;
    }

    @NotNull
    public static CFileAttributes fromStream(@NotNull DataInput aStream) throws IOException {
        CBitField bf = CBitField.fromStreamVariableLength(aStream);
        return new CFileAttributes(bf);
    }

    @NotNull
    public static CFileAttributes readFromFile(@NotNull File aFile) {
        BasicFileAttributes attr2;
        CFileAttributes attributes = new CFileAttributes();
        long time = 0L;
        Path path = aFile.toPath();
        if (LOG.isTraceEnabled()) {
            time = System.nanoTime();
        }
        attributes.setIsWindows(CUtilOS.IS_WINDOWS);
        try {
            attr2 = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            attributes.setTimeOfCreation(attr2.creationTime().toMillis());
            attributes.setTimeOfLastAccess(attr2.lastAccessTime().toMillis());
            attributes.setTimeOfLastModification(attr2.lastModifiedTime().toMillis());
            attributes.setIsDirectory(attr2.isDirectory());
            attributes.setIsOther(attr2.isOther());
            attributes.setIsRegularFile(attr2.isRegularFile());
            attributes.setIsSymbolicLink(attr2.isSymbolicLink());
            attributes.setFileSize(attr2.size());
        }
        catch (Exception attr2) {
            // empty catch block
        }
        try {
            attr2 = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
            attributes.setIsArchive(attr2.isArchive());
            attributes.setIsDirectory(attr2.isDirectory());
            attributes.setIsHidden(attr2.isHidden());
            attributes.setIsOther(attr2.isOther());
            attributes.setIsReadOnly(attr2.isReadOnly());
            attributes.setIsRegularFile(attr2.isRegularFile());
            attributes.setIsSymbolicLink(attr2.isSymbolicLink());
            attributes.setIsSystem(attr2.isSystem());
            attributes.setTimeOfLastAccess(attr2.lastAccessTime().toMillis());
            attributes.setTimeOfLastModification(attr2.lastModifiedTime().toMillis());
            attributes.setFileSize(attr2.size());
        }
        catch (Exception attr3) {
            // empty catch block
        }
        try {
            attr2 = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
            attributes.setTimeOfCreation(attr2.creationTime().toMillis());
            attributes.setGroup(attr2.group().getName());
            attributes.setIsDirectory(attr2.isDirectory());
            attributes.setIsOther(attr2.isOther());
            attributes.setIsRegularFile(attr2.isRegularFile());
            attributes.setIsSymbolicLink(attr2.isSymbolicLink());
            attributes.setTimeOfLastAccess(attr2.lastAccessTime().toMillis());
            attributes.setTimeOfLastModification(attr2.lastModifiedTime().toMillis());
            UserPrincipal owner = attr2.owner();
            if (owner != null) {
                attributes.setOwner(owner.getName());
            }
            Set<PosixFilePermission> permissions = attr2.permissions();
            CFileAttributeFactory.takePosixPermissions(attributes, permissions);
            attributes.setFileSize(attr2.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aFile.exists()) {
            attributes.setExists(true);
            attributes.setExecutable(aFile.canExecute());
        } else {
            attributes.setExists(false);
            attributes.setExecutable(false);
        }
        if (LOG.isTraceEnabled()) {
            time = System.nanoTime() - time;
            LOG.trace("Reading FileAttributes from {} in {} nano seconds", aFile.getPath(), time);
        }
        return attributes;
    }

    private static void takePosixPermissions(@NotNull CFileAttributes aAttributes, @NotNull Set<PosixFilePermission> aSet) {
        aAttributes.setIsPosixOwnerRead(aSet.contains((Object)PosixFilePermission.OWNER_READ));
        aAttributes.setIsPosixOwnerWrite(aSet.contains((Object)PosixFilePermission.OWNER_WRITE));
        aAttributes.setIsPosixOwnerExecute(aSet.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        aAttributes.setIsPosixGroupRead(aSet.contains((Object)PosixFilePermission.GROUP_READ));
        aAttributes.setIsPosixGroupWrite(aSet.contains((Object)PosixFilePermission.GROUP_WRITE));
        aAttributes.setIsPosixGroupExecute(aSet.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        aAttributes.setIsPosixOthersRead(aSet.contains((Object)PosixFilePermission.OTHERS_READ));
        aAttributes.setIsPosixOthersWrite(aSet.contains((Object)PosixFilePermission.OTHERS_WRITE));
        aAttributes.setIsPosixOthersExecute(aSet.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
    }

    public static void toStream(@NotNull CFileAttributes aAttributes, @NotNull DataOutput aStream) throws IOException {
        CBitField.toStreamVariableLength(aStream, aAttributes.getBitField());
    }

    public static void toStreamDirectory(@NotNull CFileAttributes aAttributes, @NotNull DataOutput aStream) throws IOException {
        CBitField.toStreamFixedLength(aStream, aAttributes.getBitField());
        aStream.writeLong(aAttributes.getTimeOfCreation().toMillis());
        aStream.writeLong(aAttributes.getTimeOfLastAccess().toMillis());
        aStream.writeLong(aAttributes.getTimeOfLastModification().toMillis());
    }
}

