/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.CBitField;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.EFileAttributes;
import java.nio.file.attribute.FileTime;
import org.jetbrains.annotations.NotNull;

public final class CFileAttributes {
    private static final char POSIX_FLAG_IS_FALSE = '-';
    private static final char POSIX_FLAG_DIRECTORY = 'd';
    private static final char POSIX_FLAG_READ = 'r';
    private static final char POSIX_FLAG_WRITE = 'w';
    private static final char POSIX_FLAG_EXECUTE = 'x';
    private static final char DOS_FLAG_READONLY = 'r';
    private static final char DOS_FLAG_ARCHIVE = 'a';
    private static final char DOS_FLAG_HIDDEN = 'h';
    private static final char DOS_FLAG_SYSTEM = 's';
    private static final int SIZE = 21;
    private final CBitField mAttributes;
    private FileTime mTimeOfCreation = FileTime.fromMillis(0L);
    private FileTime mTimeOfLastAccess = FileTime.fromMillis(0L);
    private FileTime mTimeOfLastModification = FileTime.fromMillis(0L);
    private long mFileSize = 0L;
    private String mOwner = null;
    private String mGroup = null;

    public CFileAttributes() {
        this.mAttributes = new CBitField(21);
    }

    public CFileAttributes(CBitField aAttributes) {
        this.mAttributes = aAttributes;
    }

    public void bitsFromString(String aString) {
        int size = this.mAttributes.size();
        CUtilCheck.checkEmptyString(aString, "Missing input String", new Object[0]);
        CUtilCheck.checkTrue(aString.length() >= size, "Invalid Argument", new Object[0]);
        for (int i = 0; i < size; ++i) {
            this.mAttributes.set(i, aString.charAt(i) == '1');
        }
    }

    public String bitsToString() {
        int size = this.mAttributes.size();
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append(this.mAttributes.get(i) ? 1 : 0);
        }
        return sb.toString();
    }

    public boolean exists() {
        return this.mAttributes.get(EFileAttributes.EXISTS.getValue());
    }

    public CBitField getBitField() {
        return this.mAttributes;
    }

    public String getDosFlags() {
        StringBuilder sb = new StringBuilder(5);
        if (this.isReadOnly()) {
            sb.append('r');
        }
        if (this.isArchive()) {
            sb.append('a');
        }
        if (this.isHidden()) {
            sb.append('h');
        }
        if (this.isSystem()) {
            sb.append('s');
        }
        return sb.toString();
    }

    public long getFileSize() {
        return this.mFileSize;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getPosixFlags() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isDirectory() ? (char)'d' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_OWNER_READ.getValue()) ? (char)'r' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_OWNER_WRITE.getValue()) ? (char)'w' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_OWNER_EXECUTE.getValue()) ? (char)'x' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_GROUP_READ.getValue()) ? (char)'r' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_GROUP_WRITE.getValue()) ? (char)'w' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_GROUP_EXECUTE.getValue()) ? (char)'x' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_OTHERS_READ.getValue()) ? (char)'r' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_OTHERS_WRITE.getValue()) ? (char)'w' : '-');
        sb.append(this.mAttributes.get(EFileAttributes.POSIX_OTHERS_EXECUTE.getValue()) ? (char)'x' : '-');
        return sb.toString();
    }

    public FileTime getTimeOfCreation() {
        return this.mTimeOfCreation;
    }

    public FileTime getTimeOfLastAccess() {
        return this.mTimeOfLastAccess;
    }

    public FileTime getTimeOfLastModification() {
        return this.mTimeOfLastModification;
    }

    public boolean isArchive() {
        return this.mAttributes.get(EFileAttributes.ARCHIVE.getValue());
    }

    public boolean isDirectory() {
        return this.mAttributes.get(EFileAttributes.DIRECTORY.getValue());
    }

    public boolean isExecutable() {
        return this.mAttributes.get(EFileAttributes.EXECUTABLE.getValue());
    }

    public boolean isHidden() {
        return this.mAttributes.get(EFileAttributes.HIDDEN.getValue());
    }

    public boolean isOther() {
        return this.mAttributes.get(EFileAttributes.OTHER.getValue());
    }

    public boolean isReadOnly() {
        return this.mAttributes.get(EFileAttributes.READONLY.getValue());
    }

    public boolean isRegularFile() {
        return this.mAttributes.get(EFileAttributes.REGULAR_FILE.getValue());
    }

    public boolean isSymbolicLink() {
        return this.mAttributes.get(EFileAttributes.SYMBOLIC_LINK.getValue());
    }

    public boolean isSystem() {
        return this.mAttributes.get(EFileAttributes.SYSTEM.getValue());
    }

    public boolean isWindows() {
        return this.mAttributes.get(EFileAttributes.IS_WINDOWS.getValue());
    }

    public void setExecutable(boolean aOn) {
        this.mAttributes.set(EFileAttributes.EXECUTABLE.getValue(), aOn);
    }

    public void setExists(boolean aOn) {
        this.mAttributes.set(EFileAttributes.EXISTS.getValue(), aOn);
    }

    public void setFileSize(long aFileSize) {
        this.mFileSize = aFileSize;
    }

    public void setGroup(String aGroup) {
        this.mGroup = aGroup;
    }

    void setIsArchive(boolean aIsArchive) {
        this.mAttributes.set(EFileAttributes.ARCHIVE.getValue(), aIsArchive);
    }

    void setIsDirectory(boolean aIsDirectory) {
        this.mAttributes.set(EFileAttributes.DIRECTORY.getValue(), aIsDirectory);
    }

    void setIsHidden(boolean aIsHidden) {
        this.mAttributes.set(EFileAttributes.HIDDEN.getValue(), aIsHidden);
    }

    void setIsOther(boolean aIsOther) {
        this.mAttributes.set(EFileAttributes.OTHER.getValue(), aIsOther);
    }

    void setIsPosixGroupExecute(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_GROUP_EXECUTE.getValue(), aOn);
    }

    void setIsPosixGroupRead(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_GROUP_READ.getValue(), aOn);
    }

    void setIsPosixGroupWrite(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_GROUP_WRITE.getValue(), aOn);
    }

    void setIsPosixOthersExecute(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_OTHERS_EXECUTE.getValue(), aOn);
    }

    void setIsPosixOthersRead(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_OTHERS_READ.getValue(), aOn);
    }

    void setIsPosixOthersWrite(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_OTHERS_WRITE.getValue(), aOn);
    }

    void setIsPosixOwnerExecute(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_OWNER_EXECUTE.getValue(), aOn);
    }

    void setIsPosixOwnerRead(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_OWNER_READ.getValue(), aOn);
    }

    void setIsPosixOwnerWrite(boolean aOn) {
        this.mAttributes.set(EFileAttributes.POSIX_OWNER_WRITE.getValue(), aOn);
    }

    void setIsReadOnly(boolean aIsReadOnly) {
        this.mAttributes.set(EFileAttributes.READONLY.getValue(), aIsReadOnly);
    }

    void setIsRegularFile(boolean aIsRegularFile) {
        this.mAttributes.set(EFileAttributes.REGULAR_FILE.getValue(), aIsRegularFile);
    }

    void setIsSymbolicLink(boolean aIsSymbolicLink) {
        this.mAttributes.set(EFileAttributes.SYMBOLIC_LINK.getValue(), aIsSymbolicLink);
    }

    void setIsSystem(boolean aIsSystem) {
        this.mAttributes.set(EFileAttributes.SYSTEM.getValue(), aIsSystem);
    }

    void setIsWindows(boolean aIsWindows) {
        this.mAttributes.set(EFileAttributes.IS_WINDOWS.getValue(), aIsWindows);
    }

    public void setOwner(String aOwner) {
        this.mOwner = aOwner;
    }

    public void setTimeOfCreation(long aTimeOfCreation) {
        this.mTimeOfCreation = FileTime.fromMillis(aTimeOfCreation);
    }

    public void setTimeOfLastAccess(long aTimeOfLastAccess) {
        this.mTimeOfLastAccess = FileTime.fromMillis(aTimeOfLastAccess);
    }

    public void setTimeOfLastModification(long aTimeOfLastModification) {
        this.mTimeOfLastModification = FileTime.fromMillis(aTimeOfLastModification);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.exists()) {
            sb.append("not existing");
        } else {
            sb.append("size=");
            sb.append(this.mFileSize);
            sb.append(" timeOfCreation=");
            sb.append(this.mTimeOfCreation);
            sb.append(" timeOfLastModification=");
            sb.append(this.mTimeOfLastModification);
            sb.append(" timeOfLastAccess=");
            sb.append(this.mTimeOfLastAccess);
            if (this.isDirectory()) {
                sb.append('D');
                sb.append(' ');
            }
            sb.append(" POSIX=");
            sb.append(this.getPosixFlags());
            sb.append(" DOS=");
            sb.append(this.getDosFlags());
        }
        sb.append(" otherFlags=");
        if (this.isSymbolicLink()) {
            sb.append('L');
        }
        if (this.isExecutable()) {
            sb.append('X');
        }
        if (CUtilString.isValid(this.mGroup)) {
            sb.append(" group=");
            sb.append(this.mGroup);
        }
        if (CUtilString.isValid(this.mOwner)) {
            sb.append(" owner=");
            sb.append(this.mOwner);
        }
        return sb.toString();
    }
}

