/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.jar;

import de.sillysky.nyssr.util.CUtilString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;

public class CUtilJar {
    @NotNull
    public static List<File> getFiles(@NotNull String paths) {
        ArrayList<File> filesList = new ArrayList<File>();
        if (CUtilString.isValid(paths)) {
            for (String path : paths.split(File.pathSeparator)) {
                File file = new File(path);
                if (file.isDirectory()) {
                    CUtilJar.recurse(filesList, file);
                    continue;
                }
                filesList.add(file);
            }
        }
        return filesList;
    }

    private static void recurse(@NotNull List<File> filesList, @NotNull File f) {
        File[] list = f.listFiles();
        if (list != null) {
            for (File file : list) {
                if (file.isDirectory()) {
                    CUtilJar.recurse(filesList, file);
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                filesList.add(file);
            }
        }
    }

    @NotNull
    public static List<String> getJarContent(@NotNull String jarPath) throws IOException {
        ArrayList<String> content = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                content.add(name);
            }
        }
        return content;
    }

    public static void main(String[] args) throws Exception {
        List<File> list = CUtilJar.getFiles(System.getProperty("java.class.path"));
        for (File file : list) {
            System.out.println(file.getPath());
        }
        list = CUtilJar.getFiles(System.getProperty("sun.boot.class.path"));
        for (File file : list) {
            System.out.println(file.getPath());
        }
        list = CUtilJar.getFiles(System.getProperty("java.ext.dirs"));
        for (File file : list) {
            System.out.println(file.getPath());
        }
        List<String> content = CUtilJar.getJarContent("c:/temp/DirWatch.jar");
        for (String file : content) {
            System.out.println(file);
        }
    }
}

