/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.streamheader;

import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.files.CResourceHandler;
import de.sillysky.nyssr.util.streamheader.CBasicStreamHeader;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderFactoryRegistry;
import de.sillysky.nyssr.util.streamheader.IStreamHeader;
import de.sillysky.nyssr.util.streamheader.IStreamHeaderFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CStreamHeaderList<T> {
    private final List<IStreamHeader> mList = new ArrayList<IStreamHeader>();

    public void add(IStreamHeader aStreamHeader) {
        this.mList.add(aStreamHeader);
    }

    public List<IStreamHeader> getAllOfType(int aType) {
        ArrayList<IStreamHeader> list = new ArrayList<IStreamHeader>();
        for (IStreamHeader h : this.mList) {
            if (h.getType() != aType) continue;
            list.add(h);
        }
        return list;
    }

    public IStreamHeader getFirst(int aType) {
        for (IStreamHeader h : this.mList) {
            if (h.getType() != aType) continue;
            return h;
        }
        return null;
    }

    public byte[] pack() {
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            @Override
            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                this.registerResource(dos);
                for (IStreamHeader header : CStreamHeaderList.this.mList) {
                    CPositiveInteger.toStream(dos, header.getType());
                    header.pack();
                    byte[] packedHeader = header.getPackedData();
                    CPositiveInteger.toStream(dos, packedHeader.length);
                    if (packedHeader.length <= 0) continue;
                    dos.write(packedHeader);
                }
                CPositiveInteger.toStream(dos, 0);
                dos.close();
                return baos.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        return (byte[])handler.getResult();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IStreamHeader h : this.mList) {
            sb.append(h.toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public void unpack(DataInput aStream, T aOwner, CStreamHeaderFactoryRegistry<T> aFactoryRegistry) throws IOException {
        int type;
        do {
            IStreamHeaderFactory<T> factory;
            CBasicStreamHeader<T> header;
            if ((type = CPositiveInteger.fromStream(aStream)) == 0) continue;
            int size = CPositiveInteger.fromStream(aStream);
            byte[] data = null;
            if (size > 0) {
                data = new byte[size];
                aStream.readFully(data);
            }
            if ((header = (factory = aFactoryRegistry.getFactory(type)) != null ? factory.createStreamHeader(type, aOwner, data) : new CBasicStreamHeader<T>(type, aOwner, data)) == null) continue;
            header.unpack();
            this.add(header);
        } while (type != 0);
    }

    public int size() {
        int size = 0;
        if (!this.mList.isEmpty()) {
            for (IStreamHeader header : this.mList) {
                size += header.getSize();
            }
        }
        return size;
    }
}

