/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.string.builder;

import de.sillysky.nyssr.util.CUtilString;

public class CStringBuilder {
    private static final char PERCENT = '%';
    private final StringBuilder mSb = new StringBuilder(10000);
    private int mTabSize = 2;
    private int mTabCount = 0;

    public void setTabSize(int aTabSize) {
        this.mTabSize = aTabSize;
    }

    private void add(String aFormat, boolean aNewLine, Object ... aObjects) {
        this.appendTab();
        String str = aObjects != null && aObjects.length > 0 && aFormat.indexOf(37) >= 0 ? String.format(aFormat, aObjects) : aFormat;
        this.mSb.append(str);
        if (aNewLine) {
            this.mSb.append(CUtilString.CRLF);
        }
    }

    public CStringBuilder append(String aStr) {
        this.mSb.append(aStr);
        return this;
    }

    public CStringBuilder append(char aChar) {
        this.mSb.append(aChar);
        return this;
    }

    public CStringBuilder appendTab() {
        for (int i = 0; i < this.mTabCount; ++i) {
            for (int s = 0; s < this.mTabSize; ++s) {
                this.append(' ');
            }
        }
        return this;
    }

    public CStringBuilder dec() {
        if (this.mTabCount > 0) {
            --this.mTabCount;
        }
        return this;
    }

    public CStringBuilder inc() {
        ++this.mTabCount;
        return this;
    }

    public CStringBuilder inc(int aTabCount) {
        this.mTabCount = aTabCount;
        return this;
    }

    public CStringBuilder newLine() {
        this.mSb.append(CUtilString.CRLF);
        return this;
    }

    public CStringBuilder print(String aFormat, Object ... aObjects) {
        this.add(aFormat, false, aObjects);
        return this;
    }

    public CStringBuilder println(String aFormat, Object ... aObjects) {
        this.add(aFormat, true, aObjects);
        return this;
    }

    public CStringBuilder setLength(int aLength) {
        this.mSb.setLength(aLength);
        return this;
    }

    public String toString() {
        return this.mSb.toString();
    }
}

