/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CButtonAndRight;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.impl.dialog.user.CUtilUserDialog;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowMessageDialog;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMessageDialogListener;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class C700Handler {
    private static final String[][] PROTECTED_ROLES = new String[][]{{"admin", "Administrator"}, {"admin", "UserManager"}, {"admin", "UserVerifier"}, {"admin", "UserViewer"}, {"guest", "Guests"}, {"guest", "UserViewer"}, {"guest", "UserVerifier"}};
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs700;
    private final CWidgetId m700PanelMain;
    private final CWidgetId m700ListUser;
    private final CWidgetId m700UserId;
    private final CWidgetId m700RealName;
    private final CWidgetId m700Email;
    private final CWidgetId m700Created;
    private final CWidgetId m700CreatedBy;
    private final CWidgetId m700ListRoles;
    private final CWidgetId m700ListRights;
    private final CWidgetId m700ButtonEditUser;
    private final CWidgetId m700ButtonDeleteUser;
    private final CWidgetId m700ButtonEditRoles;
    private final CWidgetId m700ButtonRemoveRoleFromUser;
    private final CWidgetId m700ButtonEditRight;
    private final CWidgetId m700ButtonChangePassword;
    private final CWidgetId m700ButtonCreateUser;
    private final CWidgetId m700ButtonAddRoleToUser;
    private final CButtonAndRight mButtonAndRight;
    private final CWidgetSetId mWs709;
    private CUser mUser = new CUser();
    private String mCurrentRoleId;

    C700Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance, @NotNull CButtonAndRight aButtonAndRight) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mButtonAndRight = aButtonAndRight;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs700 = CWidgetSetId.create((String)"@700_Main", (String)aInstance);
        this.m700PanelMain = CWidgetId.create((String)"#700_Panel_Main", (CWidgetSetId)this.mWs700);
        this.m700ListUser = CWidgetId.create((String)"#700_List", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ListUser, (IListener)((IListSelectionListener)this::onListUserSelection));
        this.m700UserId = CWidgetId.create((String)"#700_UserId", (CWidgetSetId)this.mWs700);
        this.m700RealName = CWidgetId.create((String)"#700_RealName", (CWidgetSetId)this.mWs700);
        this.m700Email = CWidgetId.create((String)"#700_Email", (CWidgetSetId)this.mWs700);
        this.m700Created = CWidgetId.create((String)"#700_Created", (CWidgetSetId)this.mWs700);
        this.m700CreatedBy = CWidgetId.create((String)"#700_CreatedBy", (CWidgetSetId)this.mWs700);
        this.m700ListRoles = CWidgetId.create((String)"#700_ListRoles", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ListRoles, (IListener)((IListSelectionListener)this::onListRoleSelection));
        this.m700ListRights = CWidgetId.create((String)"#700_ListRights", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ListRights, (IListener)((IListSelectionListener)this::onListRightSelection));
        this.m700ButtonEditUser = CWidgetId.create((String)"#700_ButtonEditUser", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonEditUser, (IListener)((IButtonPressedListener)this::onEditUser));
        this.m700ButtonCreateUser = CWidgetId.create((String)"#700_ButtonCreateUser", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonCreateUser, (IListener)((IButtonPressedListener)this::onCreateUser));
        this.m700ButtonDeleteUser = CWidgetId.create((String)"#700_ButtonDeleteUser", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonDeleteUser, (IListener)((IButtonPressedListener)this::onRemoveUser));
        this.mApi.addListener(this.m700ButtonDeleteUser, (IListener)((IMessageDialogListener)this::onMessageDialogRemoveUser));
        this.m700ButtonEditRoles = CWidgetId.create((String)"#700_ButtonEditRoles", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonEditRoles, (IListener)((IButtonPressedListener)this::onEditRole));
        this.m700ButtonAddRoleToUser = CWidgetId.create((String)"#700_ButtonAddRoleToUser", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonAddRoleToUser, (IListener)((IButtonPressedListener)this::onAddRole));
        this.m700ButtonRemoveRoleFromUser = CWidgetId.create((String)"#700_ButtonRemoveRoleFromUser", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonRemoveRoleFromUser, (IListener)((IButtonPressedListener)this::onRemoveRole));
        this.mApi.addListener(this.m700ButtonRemoveRoleFromUser, (IListener)((IMessageDialogListener)this::onMessageDeleteRole));
        this.m700ButtonEditRight = CWidgetId.create((String)"#700_ButtonEditRight", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonEditRight, (IListener)((IButtonPressedListener)this::onEditRight));
        this.m700ButtonChangePassword = CWidgetId.create((String)"#700_ButtonChangePassword", (CWidgetSetId)this.mWs700);
        this.mApi.addListener(this.m700ButtonChangePassword, (IListener)((IButtonPressedListener)this::onChangePassword));
        this.mWs709 = CWidgetSetId.create((String)"@709_PopupMenu", (String)aInstance);
        CWidgetId menuItemChangePassword = CWidgetId.create((String)"#709_ChangePassword", (CWidgetSetId)this.mWs709);
        this.mApi.addListener(menuItemChangePassword, (IListener)((IButtonPressedListener)this::onChangePassword));
    }

    void fillUserIdList(@NotNull @NotNull String @NotNull [] aUserIds) throws CException {
        CEventListContent event = new CEventListContent();
        for (String userId : aUserIds) {
            CEventLabelItem item = new CEventLabelItem(userId);
            item.getAttributes().setValue((Object)userId);
            event.add(item);
        }
        this.mApi.setListContent(this.m700ListUser, event);
        if (aUserIds.length > 0) {
            this.mMainTarget.sendGetUserData(aUserIds[0]);
        }
    }

    void selectUserInList(@NotNull String aUserId) {
        this.mApi.selectItem(this.m700ListUser, aUserId);
    }

    private void fillUserData() {
        this.mApi.setText(this.m700UserId, this.mUser.getId());
        this.mApi.setText(this.m700RealName, this.mUser.getRealName());
        this.mApi.setText(this.m700Email, this.mUser.getEmail());
        this.mApi.setText(this.m700Created, this.mUser.getTimeCreated().toString());
        this.mApi.setText(this.m700CreatedBy, this.mUser.getCreatedByUser());
    }

    private void fillRoles(@NotNull @NotNull String @NotNull [] aRoles) {
        CEventListContent event = new CEventListContent();
        for (String role : aRoles) {
            CEventLabelItem item = new CEventLabelItem(role);
            item.getAttributes().setValue((Object)role);
            event.add(item);
        }
        this.mApi.setListContent(this.m700ListRoles, event);
    }

    private void fillRights(@NotNull @NotNull String @NotNull [] aRights) {
        CEventListContent event = new CEventListContent();
        for (String right : aRights) {
            CEventLabelItem item = new CEventLabelItem(right);
            item.getAttributes().setValue((Object)right);
            event.add(item);
        }
        this.mApi.setListContent(this.m700ListRights, event);
    }

    private void onChangePassword(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notifyButtonChangePassword(this.m700PanelMain);
    }

    private void onEditUser(@NotNull CEventButtonPressedNotification aEvent) {
        this.mMainTarget.notifyButtonEditUser();
    }

    private void onCreateUser(@NotNull CEventButtonPressedNotification aEvent) {
        this.mMainTarget.notifyButtonAddUserPressed();
    }

    private void onRemoveUser(@NotNull CEventButtonPressedNotification aEvent) {
        CEventShowMessageDialog event = new CEventShowMessageDialog("Do you really want to remove user \"" + this.mUser.getId() + "?\"");
        event.setTitle("Remove User");
        event.setButtons(new String[]{"Okay", "Cancel"});
        event.setDefaultButton("Okay");
        event.setIcon(CEventIcon.fromObject((Object)"user.png"));
        this.mApi.showMessageDialog(this.m700ButtonDeleteUser, event);
        this.mServerContext.sendUpdate();
    }

    private void onMessageDialogRemoveUser(@Nullable String aButton) throws CException {
        if ("Okay".equals(aButton)) {
            this.mMainTarget.notifyButtonRemoveUserPressed(this.mUser.getId());
        }
    }

    private void onEditRole(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notifyButtonEditRoles();
    }

    private void onAddRole(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notifyButtonAddRolePressed();
    }

    private void onRemoveRole(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        if (CUtilString.isValid((String)this.mCurrentRoleId)) {
            if (this.checkRemoveRole(this.mUser.getId(), this.mCurrentRoleId)) {
                return;
            }
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(this.mCurrentRoleId);
            this.mMainTarget.notifyButtonRemoveRolePressed(this.mUser.getId(), roles);
        }
    }

    private boolean checkRemoveRole(@NotNull String aUserId, @NotNull String aRole) {
        for (String[] record : PROTECTED_ROLES) {
            if (!record[0].equals(aUserId) || !record[1].equals(aRole)) continue;
            String s = String.format("You can't remove role %s from user %s", aRole, aUserId);
            this.showMessageBox(s);
            return true;
        }
        return false;
    }

    private void onMessageDeleteRole(@Nullable String aButtonText) {
    }

    private void showMessageBox(@NotNull String aText) {
        CEventShowMessageDialog event = new CEventShowMessageDialog(aText);
        event.setTitle("User Manager");
        event.setButtons(new String[]{"Okay"});
        event.setDefaultButton("Okay");
        event.setIcon(CEventIcon.fromObject((Object)"user.png"));
        this.mApi.showMessageDialog(this.m700ButtonRemoveRoleFromUser, event);
        this.mServerContext.sendUpdate();
    }

    private void onEditRight(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notifyButtonEditRights();
    }

    private void onListUserSelection(@NotNull CEventListSelectionNotification aEvent) throws CException {
        List selectedIds = aEvent.getSelectedIds();
        for (String id : selectedIds) {
            this.mMainTarget.sendGetUserData(id);
        }
    }

    private void onListRoleSelection(@NotNull CEventListSelectionNotification aEvent) {
        List selectedIds = aEvent.getSelectedIds();
        Iterator iterator = selectedIds.iterator();
        while (iterator.hasNext()) {
            String id;
            this.mCurrentRoleId = id = (String)iterator.next();
        }
    }

    private void onListRightSelection(@NotNull CEventListSelectionNotification aEvent) {
        List selectedIds = aEvent.getSelectedIds();
        if (!selectedIds.isEmpty()) {
            this.mApi.setEnabled(this.m700ButtonEditRight, true);
            this.sendUpdate();
        }
    }

    void mount(@NotNull CWidgetId aParentWidget) {
        this.mButtonAndRight.addAll(this.m700ButtonCreateUser, this.m700ButtonDeleteUser, this.m700ButtonEditUser, this.m700ButtonChangePassword, this.m700ButtonAddRoleToUser, this.m700ButtonRemoveRoleFromUser);
        this.mServerContext.mountWidgetSet(this.mWs700, aParentWidget, "#700_Panel_Main", this::widgetSetMounted);
        this.sendUpdate();
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) throws CException {
        if (this.mWs700.equals((Object)aWidgetSetId)) {
            this.mMainTarget.notifyWs700Loaded();
            if (CUtilUserDialog.hasRight(this.mMainTarget.getSessionRights(), "NY_UpdateUser")) {
                this.mApi.setEnabled(this.m700ButtonEditUser, true);
            }
            if (CUtilUserDialog.hasRight(this.mMainTarget.getSessionRights(), "NY_CreateUser")) {
                this.mApi.setEnabled(this.m700ButtonCreateUser, true);
            }
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    CWidgetId getMainPanel() {
        return this.m700PanelMain;
    }

    void updateUser(@NotNull CUser aUser, @NotNull String[] aRoles, @NotNull String[] aRights) {
        this.mUser = new CUser(aUser);
        this.fillUserData();
        this.fillRoles(aRoles);
        this.fillRights(aRights);
        this.mButtonAndRight.check(this.mUser, null, this.m700ButtonCreateUser, "NY_CreateUser");
        this.mButtonAndRight.check(this.mUser, null, this.m700ButtonDeleteUser, "NY_DeleteUser");
        this.mButtonAndRight.check(this.mUser, this.mUser.getId(), this.m700ButtonEditUser, "NY_UpdateUser");
        this.mButtonAndRight.check(this.mUser, this.mUser.getId(), this.m700ButtonChangePassword, "NY_ChangePassword");
        this.mButtonAndRight.check(this.mUser, null, this.m700ButtonAddRoleToUser, "NY_AddRoleToUser");
        this.mButtonAndRight.check(this.mUser, null, this.m700ButtonRemoveRoleFromUser, "NY_RemoveRoleFromUser");
        this.sendUpdate();
    }
}

