/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.listbox;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.listbox.CListBoxModel;
import de.sillysky.nyssr.remoteskin.model.enums.EListBoxLayout;
import de.sillysky.nyssr.remoteskin.model.enums.EListSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventColorChooserDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowColorChooserDialog;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IColorChooserListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IComboBoxSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IIntegerListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.util.CUtilEnum;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class CListBoxUi {
    private final CListBoxModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs316;
    private final CWidgetId mListBox4;
    private final CWidgetId mListBox5;
    private final CWidgetId mListBox6;
    private final CWidgetId mListBox7;
    private final CWidgetId mButton6b;
    private final CWidgetId mButton6a;
    private final CWidgetId mListBox8;
    private final CWidgetId mListBox9;
    private final CWidgetId mScrollPane9;
    private CWidgetId m316PanelMain;

    public CListBoxUi(@NotNull CListBoxModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = this.mModel.getParent().getWidgetSetId().getInstance();
        this.mWs316 = CWidgetSetId.create((String)"@316_ListBox", (String)instance);
        for (int i = 0; i <= 10; ++i) {
            CWidgetId listBox = CWidgetId.create((String)("#316_Component_" + i), (CWidgetSetId)this.mWs316);
            this.mApi.addListener(listBox, (IListener)((IListSelectionListener)this::onListBoxSelect));
        }
        this.mListBox4 = CWidgetId.create((String)"#316_Component_4", (CWidgetSetId)this.mWs316);
        CWidgetId comboBox4 = CWidgetId.create((String)"#316_Helper_4", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(comboBox4, (IListener)((IComboBoxSelectionListener)this::onComboBoxSelect4));
        this.mListBox5 = CWidgetId.create((String)"#316_Component_5", (CWidgetSetId)this.mWs316);
        CWidgetId helper5b = CWidgetId.create((String)"#316_Helper_5b", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(helper5b, (IListener)((IIntegerListener)this::onHelper5b));
        CWidgetId helper5d = CWidgetId.create((String)"#316_Helper_5d", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(helper5d, (IListener)((IIntegerListener)this::onHelper5d));
        this.mListBox6 = CWidgetId.create((String)"#316_Component_6", (CWidgetSetId)this.mWs316);
        this.mButton6a = CWidgetId.create((String)"#316_Helper_6a", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(this.mButton6a, (IListener)((IButtonPressedListener)this::onHelper6a));
        this.mApi.addListener(this.mButton6a, (IListener)((IColorChooserListener)this::onColorChooser6a));
        this.mButton6b = CWidgetId.create((String)"#316_Helper_6b", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(this.mButton6b, (IListener)((IButtonPressedListener)this::onHelper6b));
        this.mApi.addListener(this.mButton6b, (IListener)((IColorChooserListener)this::onColorChooser6b));
        this.mListBox7 = CWidgetId.create((String)"#316_Component_7", (CWidgetSetId)this.mWs316);
        CWidgetId comboBox7 = CWidgetId.create((String)"#316_Helper_7", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(comboBox7, (IListener)((IComboBoxSelectionListener)this::onComboBoxSelect7));
        this.mListBox8 = CWidgetId.create((String)"#316_Component_8", (CWidgetSetId)this.mWs316);
        CWidgetId helper8b = CWidgetId.create((String)"#316_Helper_8b", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(helper8b, (IListener)((IIntegerListener)this::onHelper8b));
        this.mListBox9 = CWidgetId.create((String)"#316_Component_9", (CWidgetSetId)this.mWs316);
        this.mScrollPane9 = CWidgetId.create((String)"#316_ScrollComponent_9", (CWidgetSetId)this.mWs316);
        CWidgetId helper9 = CWidgetId.create((String)"#316_Helper_9", (CWidgetSetId)this.mWs316);
        this.mApi.addListener(helper9, (IListener)((IButtonPressedListener)this::onHelper9));
    }

    private void onListBoxSelect(@NotNull CEventListSelectionNotification aEvent) {
        this.mModel.getAppContext().addMessage("List entries selected: " + aEvent.getSelectedIds().toString());
    }

    private void onComboBoxSelect4(@NotNull CEventComboBoxSelectionNotification aEvent) {
        String id = aEvent.getEntryId();
        EListBoxLayout mode = (EListBoxLayout)CUtilEnum.fromString(EListBoxLayout.class, (String)id, (Object)EListBoxLayout.vertical);
        this.mApi.setListBoxLayout(this.mListBox4, mode);
        this.mServerContext.sendUpdate();
    }

    private void onHelper5b(@NotNull CEventInteger aEvent) {
        this.mApi.setFixedCellWidth(this.mListBox5, aEvent.getValue());
        this.mServerContext.sendUpdate();
    }

    private void onHelper5d(@NotNull CEventInteger aEvent) {
        this.mApi.setFixedCellHeight(this.mListBox5, aEvent.getValue());
        this.mServerContext.sendUpdate();
    }

    private void onHelper6a(@NotNull CEventButtonPressedNotification aEvent) {
        this.mApi.showColorChooserDialog(this.mButton6a, new CEventShowColorChooserDialog(true, "Choose a background color:", new CEventColor("OrangeRed", 255), new CEventWidgetId(this.mButton6a)));
        this.mServerContext.sendUpdate();
    }

    private void onColorChooser6a(@NotNull CEventColorChooserDialogNotification aEvent) {
        CEventColor eventColor = aEvent.getColor();
        if (eventColor != null) {
            this.mApi.setSelectionBackground(this.mListBox6, eventColor);
            this.mApi.setBackgroundColor(this.mButton6a, eventColor);
            this.mApi.setBackgroundColor(this.mButton6b, eventColor);
            this.mServerContext.sendUpdate();
        }
    }

    private void onHelper6b(@NotNull CEventButtonPressedNotification aEvent) {
        this.mApi.showColorChooserDialog(this.mButton6b, new CEventShowColorChooserDialog(true, "Choose a foreground color:", new CEventColor(Color.WHITE), new CEventWidgetId(this.mButton6b)));
        this.mServerContext.sendUpdate();
    }

    private void onColorChooser6b(@NotNull CEventColorChooserDialogNotification aEvent) {
        CEventColor eventColor = aEvent.getColor();
        if (eventColor != null) {
            this.mApi.setSelectionForeground(this.mListBox6, eventColor);
            this.mApi.setForegroundColor(this.mButton6a, eventColor);
            this.mApi.setForegroundColor(this.mButton6b, eventColor);
            this.mServerContext.sendUpdate();
        }
    }

    private void onComboBoxSelect7(@NotNull CEventComboBoxSelectionNotification aEvent) {
        String id = aEvent.getEntryId();
        EListSelectionMode mode = (EListSelectionMode)CUtilEnum.fromString(EListSelectionMode.class, (String)id, (Object)EListSelectionMode.single);
        this.mApi.setListSelectionMode(this.mListBox7, mode);
        this.mServerContext.sendUpdate();
    }

    private void onHelper8b(@NotNull CEventInteger aEvent) {
        this.mApi.setVisibleRowCount(this.mListBox8, aEvent.getValue());
        this.mServerContext.sendUpdate();
    }

    private void onHelper9(@NotNull CEventButtonPressedNotification aEvent) {
        boolean selected = aEvent.isSelected();
        this.mApi.setOpaque(this.mScrollPane9, selected);
        this.mApi.setOpaque(this.mListBox9, selected);
        this.mServerContext.sendUpdate();
    }

    private void widgetSet316Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.m316PanelMain = CWidgetId.create((String)"#316_Panel_Main", (CWidgetSetId)this.mWs316);
        this.mApi.setVisible(this.m316PanelMain, true);
        this.mServerContext.sendUpdate();
        this.mModel.getAppContext().sendOtherWidgetSets();
    }

    void mountWidgetSet316() {
        this.mServerContext.mountWidgetSet(this.mWs316, this.mModel.getParent(), "#316_Panel_Main", this::widgetSet316Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m316PanelMain);
    }
}

