/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetId;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilReference {
    public static final String PREFIX_WIDGET_SET = "@";
    public static final String PREFIX_WIDGET = "#";
    public static final String PREFIX_INSTANCE = "*";
    public static final String COLON = ",";

    private CUtilReference() {
    }

    public static String makeWidgetSetId(@NotNull String aId) {
        CUtilReference.stripPrefix(aId);
        return PREFIX_WIDGET_SET + aId;
    }

    public static String makeWidgetId(@NotNull String aId) {
        CUtilReference.stripPrefix(aId);
        return PREFIX_WIDGET + aId;
    }

    public static boolean isWidgetSet(@Nullable String aId) {
        if (CUtilString.isValid((String)aId)) {
            return aId.startsWith(PREFIX_WIDGET_SET);
        }
        return false;
    }

    public static boolean isWidgetSetInstance(@Nullable String aId) {
        if (CUtilString.isValid((String)aId)) {
            return aId.startsWith(PREFIX_INSTANCE);
        }
        return false;
    }

    public static boolean isWidgetId(@Nullable String aId) {
        if (CUtilString.isValid((String)aId)) {
            return aId.startsWith(PREFIX_WIDGET);
        }
        return false;
    }

    public static String stripPrefix(@NotNull String aId) {
        if (aId.startsWith(PREFIX_WIDGET_SET)) {
            return aId.substring(PREFIX_WIDGET_SET.length()).toLowerCase();
        }
        if (aId.startsWith(PREFIX_WIDGET)) {
            return aId.substring(PREFIX_WIDGET.length()).toLowerCase();
        }
        if (aId.startsWith(PREFIX_INSTANCE)) {
            return aId.substring(PREFIX_INSTANCE.length()).toLowerCase();
        }
        return aId.toLowerCase();
    }

    public static CWidget parseReference(@NotNull CWidget aParent, @NotNull Object aValue) throws Exception {
        CWidgetId wid = CUtilReference.parse(aValue, aParent.getWidgetSet().getId());
        if (wid != null) {
            return CUtilReference.findOrMountWidget(aParent, wid);
        }
        return null;
    }

    @Nullable
    public static CWidgetId parse(@Nullable Object aValue, Object ... aHints) {
        if (aValue instanceof CWidgetId) {
            return (CWidgetId)aValue;
        }
        if (aValue instanceof String) {
            return CUtilReference.parseString((String)aValue, aHints);
        }
        if (aValue instanceof CJsonObject) {
            return CUtilReference.parseJsonObject((CJsonObject)aValue);
        }
        return null;
    }

    @Nullable
    private static CWidgetId parseJsonObject(CJsonObject aValue) {
        CEventWidgetId event = CEventWidgetId.create(aValue);
        return event == null ? null : event.getWidgetId();
    }

    @Nullable
    private static CWidgetId parseString(@NotNull String aValue, Object ... aHints) {
        String[] split;
        String w = null;
        String ws = null;
        String wsi = null;
        for (String s : split = aValue.split(COLON)) {
            if (CUtilReference.isWidgetId(s)) {
                w = s;
                continue;
            }
            if (CUtilReference.isWidgetSet(s)) {
                ws = s;
                continue;
            }
            if (!CUtilReference.isWidgetSetInstance(s)) continue;
            wsi = s;
        }
        if (CUtilString.isValid(w)) {
            if (CUtilString.isEmpty(ws) && aHints != null && aHints.length > 0 && aHints[0] instanceof CWidgetSetId) {
                CWidgetSetId widgetSetId = (CWidgetSetId)aHints[0];
                return CWidgetId.create((String)w, (CWidgetSetId)widgetSetId);
            }
            return CWidgetId.create((String)w, ws, wsi);
        }
        return null;
    }

    public static CWidget findOrMountWidget(@NotNull CWidget aParent, @NotNull CWidgetId aWidgetId) throws Exception {
        CWidgetSetId widgetSetId = aWidgetId.getWidgetSetId();
        CWidget widget = aParent.getWidgetSet().getContext().findOrMountWidgetSet(aParent, widgetSetId);
        return widget;
    }

    public static CWidgetSetId parseWidgetSetId(@NotNull Object aValue) {
        CEventWidgetSetId event;
        if (aValue instanceof String) {
            String[] split;
            String ws = null;
            String wsi = null;
            String value = (String)aValue;
            for (String s : split = value.split(COLON)) {
                if (CUtilReference.isWidgetSet(s)) {
                    ws = s;
                    continue;
                }
                if (!CUtilReference.isWidgetSetInstance(s)) continue;
                wsi = s;
            }
            return CWidgetSetId.create(ws, wsi);
        }
        if (aValue instanceof CJsonObject && (event = CEventWidgetSetId.create(aValue)) != null) {
            return event.getWidgetSetId();
        }
        return null;
    }
}

