/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.swing.key.CUtilKeyCodes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMnemonic
implements IRemoteSkinEvent {
    private final String mMnemonic;

    public CEventMnemonic(@NotNull String aMnemonic) {
        this.mMnemonic = aMnemonic;
    }

    @Nullable
    public static CEventMnemonic create(@Nullable Object aValue) {
        if (aValue instanceof String) {
            return new CEventMnemonic((String)aValue);
        }
        return null;
    }

    public String getMnemonic() {
        return this.mMnemonic;
    }

    public int getSwingConstant() {
        String normalized = CUtilNormalize.normalize((String)this.mMnemonic);
        if (!normalized.startsWith("vk")) {
            normalized = "vk" + normalized;
        }
        return CUtilKeyCodes.getIntegerMap().get(normalized, -1);
    }

    public char getCharacter() {
        return CUtilString.isEmpty((String)this.mMnemonic) ? (char)'\u0000' : this.mMnemonic.charAt(0);
    }

    @Override
    @NotNull
    public Object toJson() {
        return this.mMnemonic;
    }
}

