/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.client.handling;

import de.sillysky.nyssr.impl.network.client.handling.IDependencies;
import de.sillysky.nyssr.network.client.handling.IClientHandlingService;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilBoolean;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CClientHandlingService
implements IService,
IClientHandlingService {
    private final IDependencies mDependencies;
    private boolean mAlternateClientRouting = false;

    CClientHandlingService(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.readPreferences();
        aServiceRegistry.registerService(IClientHandlingService.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService((Object)this);
    }

    private void readPreferences() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
        String s = preferences.get("network.routing.client.alternate", null);
        this.mAlternateClientRouting = CUtilBoolean.fromString((String)s, (boolean)false);
    }

    public boolean isAlternateRoutingEnabled() {
        return this.mAlternateClientRouting;
    }
}

