/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.util.CTargetAddressList;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.network.index.CDtoAppListener;
import de.sillysky.nyssr.impl.network.index.EAction;
import de.sillysky.nyssr.impl.network.index.IInternalNetworkIndex;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.index.INetworkIndex;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexAddAppListener;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexRemoveAllListener;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexRemoveAppListener;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CNetworkIndexApi
implements INetworkIndex,
IInternalNetworkIndex,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNetworkIndexApi.class);
    private static final UUID TYPE = UUID.randomUUID();
    private final Set<CDtoAppListener> mListener = new CopyOnWriteArraySet<CDtoAppListener>();
    private final AtomicReference<ITarget> mTarget = new AtomicReference();
    private IRouter mRouter;
    private IListenerRegistry mListenerRegistry;

    public static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IRouter.class);
        aDependencyList.add(IListenerRegistry.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mRouter = (IRouter)aServiceRegistry.getService(IRouter.class);
        this.mListenerRegistry = (IListenerRegistry)aServiceRegistry.getService(IListenerRegistry.class);
        aServiceRegistry.registerService(INetworkIndex.class, (Object)this);
        aServiceRegistry.registerService(IInternalNetworkIndex.class, (Object)this);
    }

    public void addApplicationListener(@NotNull CTargetAddress aListener, @Nullable UUID aApplicationId, @Nullable CStringProperties aProperties) {
        CUtilCheck.checkNotNull((Object)aListener, (String)"Missing listener address", (Object[])new Object[0]);
        this.mListener.add(new CDtoAppListener(aListener, aApplicationId, aProperties, EAction.ADD));
        this.processListeners();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deregisterNetworkIndex(CTargetAddress aAddress) {
        CUtilCheck.checkNotNull((Object)aAddress, (String)"Missing address", (Object[])new Object[0]);
        this.mListenerRegistry.removeAddress(TYPE, aAddress);
    }

    public CTargetAddress getAddressOfNextNetworkIndex() {
        Collection nodeList;
        CNodeAddress cheapest;
        CTargetAddressList targetAddressList = this.mListenerRegistry.getTargetAddressList(TYPE);
        if (targetAddressList != null && (cheapest = this.mRouter.getCheapestNode(nodeList = targetAddressList.getNodeList())) != null) {
            for (CTargetAddress a : this.mListenerRegistry.getAddresses(TYPE)) {
                if (!cheapest.equals((Object)a.getNodeAddress())) continue;
                return a;
            }
        }
        return null;
    }

    public Collection<CTargetAddress> getAddressesOfAllNetworkIndex() {
        return this.mListenerRegistry.getListenerList(TYPE);
    }

    private void processListeners() {
        CTargetAddress index = this.getAddressOfNextNetworkIndex();
        ITarget target = this.mTarget.get();
        if (index != null && target != null) {
            for (CDtoAppListener li : this.mListener) {
                CStringProperties properties;
                UUID appId;
                CRecord record;
                CEnvelope env;
                if (li.isTransferred()) continue;
                if (li.getAction() == EAction.ADD) {
                    try {
                        env = CEnvelope.forSingleTarget((CTargetAddress)index);
                        record = CRecordNetworkIndexAddAppListener.create();
                        CRecordNetworkIndexAddAppListener.setListener((CRecord)record, (CTargetAddress)li.getListener());
                        appId = li.getApplicationId();
                        if (appId != null) {
                            CRecordNetworkIndexAddAppListener.setApplicationId((CRecord)record, (UUID)appId);
                        }
                        if ((properties = li.getProperties()) != null) {
                            CRecordNetworkIndexAddAppListener.setFilter((CRecord)record, (CStringProperties)properties);
                        }
                        target.sendNotification(env, record);
                        li.setTransferred(true);
                    }
                    catch (CException e) {
                        LOG.error((Throwable)e, "Error adding AppListener to NetworkApi");
                    }
                    continue;
                }
                if (li.getAction() == EAction.REMOVE) {
                    try {
                        env = CEnvelope.forSingleTarget((CTargetAddress)index);
                        record = CRecordNetworkIndexRemoveAppListener.create();
                        CRecordNetworkIndexRemoveAppListener.setListener((CRecord)record, (CTargetAddress)li.getListener());
                        appId = li.getApplicationId();
                        if (appId != null) {
                            CRecordNetworkIndexRemoveAppListener.setApplicationId((CRecord)record, (UUID)appId);
                        }
                        if ((properties = li.getProperties()) != null) {
                            CRecordNetworkIndexRemoveAppListener.setFilter((CRecord)record, (CStringProperties)properties);
                        }
                        target.sendNotification(env, record);
                        li.setTransferred(true);
                    }
                    catch (CException e) {
                        LOG.error((Throwable)e, "Error removing AppListener from NetworkApi");
                    }
                    continue;
                }
                if (li.getAction() != EAction.REMOVE_ALL) continue;
                try {
                    env = CEnvelope.forSingleTarget((CTargetAddress)index);
                    record = CRecordNetworkIndexRemoveAllListener.create();
                    CRecordNetworkIndexRemoveAllListener.setListener((CRecord)record, (CTargetAddress)li.getListener());
                    target.sendNotification(env, record);
                    li.setTransferred(true);
                }
                catch (CException e) {
                    LOG.error((Throwable)e, "Error removing AppListener from NetworkApi");
                }
            }
        }
    }

    @Override
    public void registerNetworkIndex(CTargetAddress aAddress) {
        this.mListenerRegistry.addAddress(TYPE, aAddress);
    }

    public void removeAllListener(CTargetAddress aListener) {
        CUtilCheck.checkNotNull((Object)aListener, (String)"Missing listener address", (Object[])new Object[0]);
        this.mListener.add(new CDtoAppListener(aListener, null, null, EAction.REMOVE_ALL));
        this.processListeners();
    }

    public void removeAllListener(CTargetAddress aListener, UUID aApplicationId, CStringProperties aProperties) {
        CUtilCheck.checkNotNull((Object)aListener, (String)"Missing listener address", (Object[])new Object[0]);
        this.mListener.add(new CDtoAppListener(aListener, aApplicationId, aProperties, EAction.REMOVE));
        this.processListeners();
    }

    private void removeNodeId(CNodeAddress aNode) {
        this.mListenerRegistry.getTargetAddressList(TYPE).removeNode(aNode);
    }

    private void removeTargetAddress(CTargetAddress aAddress) {
        ArrayList<CDtoAppListener> toRemove = new ArrayList<CDtoAppListener>();
        for (CDtoAppListener dto : this.mListener) {
            if (!dto.getListener().equals((Object)aAddress)) continue;
            toRemove.add(dto);
        }
        this.mListener.removeAll(toRemove);
    }

    @Override
    public void setTarget(ITarget aTarget) {
        this.mTarget.set(aTarget);
    }
}

